package charactermanaj.model;

import java.io.Serializable;

public class PartsSpec implements Serializable {

	private static final long serialVersionUID = -1206398362029120416L;

	private PartsIdentifier partsIdentifier;
	
	private ColorGroup colorGroup = ColorGroup.NA;
	
	private PartsFiles partsFiles;
	
	public PartsSpec(PartsIdentifier partsIdentifier) {
		if (partsIdentifier == null) {
			throw new IllegalArgumentException();
		}
		this.partsIdentifier = partsIdentifier;
		this.partsFiles = new PartsFiles(partsIdentifier);
	}
	
	public PartsIdentifier getPartsIdentifier() {
		return partsIdentifier;
	}
	
	public PartsFiles getPartsFiles() {
		return partsFiles;
	}
	
	public void setColorGroup(ColorGroup colorGroup) {
		if (colorGroup == null) {
			colorGroup = ColorGroup.NA;
		}
		this.colorGroup = colorGroup;
	}
	
	public ColorGroup getColorGroup() {
		return colorGroup;
	}
	
}
