/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.graphics;

import charactermanaj.graphics.ColorConvertedImageCachedLoader;
import charactermanaj.graphics.ImageBuildPartsInfo;
import charactermanaj.graphics.filters.ColorConvertParameter;
import charactermanaj.graphics.io.ImageResource;
import charactermanaj.model.Layer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class ImageBuilder {
    private static final int MAX_TIMEOUT = 20;
    private ColorConvertedImageCachedLoader imageLoader;

    public ImageBuilder(ColorConvertedImageCachedLoader colorConvertedImageCachedLoader) {
        if (colorConvertedImageCachedLoader == null) {
            throw new IllegalArgumentException();
        }
        this.imageLoader = colorConvertedImageCachedLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requestJob(ImageBuildJob imageBuildJob) {
        if (imageBuildJob == null) {
            throw new IllegalArgumentException();
        }
        final ArrayList arrayList = new ArrayList();
        final Rectangle rectangle = new Rectangle(0, 0, 0, 0);
        final Color[] colorArray = new Color[1];
        final Object[] objectArray = new Object[1];
        final Semaphore semaphore = new Semaphore(0);
        try {
            imageBuildJob.loadParts(new ImageSourceCollector(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void setSize(Dimension dimension) {
                    Rectangle rectangle2 = rectangle;
                    synchronized (rectangle2) {
                        rectangle.width = dimension.width;
                        rectangle.height = dimension.height;
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void setImageBgColor(Color color) {
                    Color[] colorArray2 = colorArray;
                    synchronized (colorArray) {
                        colorArray[0] = color;
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void setAffineTramsform(double[] dArray) {
                    if (dArray != null && dArray.length != 4 && dArray.length != 6) {
                        throw new IllegalArgumentException("affineTransformParameter invalid length.");
                    }
                    Object[] objectArray2 = objectArray;
                    synchronized (objectArray) {
                        objectArray[0] = dArray;
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void setImageSource(Layer layer, ImageResource imageResource, ColorConvertParameter colorConvertParameter) {
                    ArrayList arrayList2 = arrayList;
                    synchronized (arrayList2) {
                        arrayList.add(new ImageBuildPartsInfo(arrayList.size(), layer, imageResource, colorConvertParameter));
                    }
                }

                public void setComplite() {
                    semaphore.release();
                }
            });
            if (!semaphore.tryAcquire(20L, TimeUnit.SECONDS)) {
                throw new RuntimeException("ImageCollector Timeout.");
            }
        }
        catch (Exception exception) {
            imageBuildJob.handleException(exception);
            return false;
        }
        try {
            BufferedImage bufferedImage;
            Cloneable cloneable;
            Collections.sort(arrayList);
            BufferedImage bufferedImage2 = new BufferedImage(rectangle.width, rectangle.height, 2);
            Graphics2D graphics2D = (Graphics2D)bufferedImage2.getGraphics();
            try {
                int n;
                int n2;
                cloneable = rectangle;
                synchronized (cloneable) {
                    n2 = rectangle.width;
                    n = rectangle.height;
                }
                cloneable = arrayList;
                synchronized (cloneable) {
                    for (ImageBuildPartsInfo imageBuildPartsInfo : arrayList) {
                        ImageResource imageResource = imageBuildPartsInfo.getFile();
                        ColorConvertParameter colorConvertParameter = imageBuildPartsInfo.getColorParam();
                        try {
                            BufferedImage bufferedImage3 = this.imageLoader.load(imageResource, colorConvertParameter);
                            graphics2D.drawImage(bufferedImage3, 0, 0, n2, n, 0, 0, n2, n, null);
                        }
                        catch (Exception exception) {
                            imageBuildJob.handleException(exception);
                        }
                    }
                }
            }
            finally {
                graphics2D.dispose();
            }
            double[] dArray = (double[])objectArray[0];
            if (dArray == null) {
                bufferedImage = bufferedImage2;
            } else {
                cloneable = new AffineTransform(new double[]{-1.0, 0.0, 0.0, 1.0, rectangle.width, 0.0});
                AffineTransformOp affineTransformOp = new AffineTransformOp((AffineTransform)cloneable, null);
                bufferedImage = new BufferedImage(rectangle.width, rectangle.height, 2);
                affineTransformOp.filter(bufferedImage2, bufferedImage);
            }
            imageBuildJob.buildImage(new ImageOutput(){

                public BufferedImage getImageOutput() {
                    return bufferedImage;
                }

                public Color getImageBgColor() {
                    return colorArray[0];
                }
            });
        }
        catch (Exception exception) {
            imageBuildJob.handleException(exception);
            return false;
        }
        return true;
    }

    public static interface ImageBuildJob {
        public void loadParts(ImageSourceCollector var1) throws Exception;

        public void buildImage(ImageOutput var1) throws Exception;

        public void handleException(Exception var1);
    }

    public static interface ImageOutput {
        public Color getImageBgColor();

        public BufferedImage getImageOutput();
    }

    public static interface ImageSourceCollector {
        public void setSize(Dimension var1);

        public void setImageBgColor(Color var1);

        public void setAffineTramsform(double[] var1);

        public void setImageSource(Layer var1, ImageResource var2, ColorConvertParameter var3);

        public void setComplite();
    }
}

