/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.graphics.filters;

public class ColorQuantizer {
    NODE m_pTree;
    int m_nLeafCount;
    NODE[] m_pReducibleNodes = new NODE[9];
    int m_nMaxColors;
    int m_nOutputMaxColors;
    int m_nColorBits;

    public ColorQuantizer(int n, int n2) {
        this.m_nColorBits = n2 < 8 ? n2 : 8;
        this.m_pTree = null;
        this.m_nLeafCount = 0;
        for (int i = 0; i <= this.m_nColorBits; ++i) {
            this.m_pReducibleNodes[i] = null;
        }
        this.m_nMaxColors = this.m_nOutputMaxColors = n;
        if (this.m_nMaxColors < 16) {
            this.m_nMaxColors = 16;
        }
    }

    public void finalize() {
        if (this.m_pTree != null) {
            NodePointer nodePointer = new NodePointer(this.m_pTree);
            this.DeleteTree(nodePointer);
            this.m_pTree = nodePointer.value;
        }
    }

    public boolean ProcessImage(int[] nArray, int[] nArray2, int n, int n2, int n3, long l) {
        int n4 = 0;
        int n5 = (n3 * n + 31) / 32 * 4;
        switch (n3) {
            case 1: 
            case 4: 
            case 8: {
                for (int i = 0; i < n2; ++i) {
                    for (int j = 0; j < n; ++j) {
                        int n6 = this.GetPixelIndex(j, i, n3, n5, nArray);
                        int n7 = nArray2[n6] & 0xFF;
                        int n8 = nArray2[n6] >> 8 & 0xFF;
                        int n9 = nArray2[n6] >> 16 & 0xFF;
                        int n10 = nArray2[n6] >> 24 & 0xFF;
                        IntPointer intPointer = new IntPointer(this.m_nLeafCount);
                        NodePointer nodePointer = new NodePointer(this.m_pTree);
                        this.AddColor(nodePointer, n9, n8, n7, n10, this.m_nColorBits, 0, intPointer, this.m_pReducibleNodes);
                        this.m_pTree = nodePointer.value;
                        this.m_nLeafCount = intPointer.value;
                        while (this.m_nLeafCount > this.m_nMaxColors) {
                            intPointer.value = this.m_nLeafCount;
                            this.ReduceTree(this.m_nColorBits, intPointer, this.m_pReducibleNodes);
                            this.m_nLeafCount = intPointer.value;
                        }
                    }
                }
                break;
            }
            case 24: 
            case 32: {
                for (int i = 0; i < n2; ++i) {
                    for (int j = 0; j < n; ++j) {
                        int n11 = nArray[n4] & 0xFF;
                        int n12 = nArray[n4] >> 8 & 0xFF;
                        int n13 = nArray[n4] >> 16 & 0xFF;
                        int n14 = n3 == 32 ? nArray[n4] >> 24 & 0xFF : 255;
                        ++n4;
                        IntPointer intPointer = new IntPointer(this.m_nLeafCount);
                        NodePointer nodePointer = new NodePointer(this.m_pTree);
                        this.AddColor(nodePointer, n13, n12, n11, n14, this.m_nColorBits, 0, intPointer, this.m_pReducibleNodes);
                        this.m_pTree = nodePointer.value;
                        this.m_nLeafCount = intPointer.value;
                        while (this.m_nLeafCount > this.m_nMaxColors) {
                            intPointer.value = this.m_nLeafCount;
                            this.ReduceTree(this.m_nColorBits, intPointer, this.m_pReducibleNodes);
                            this.m_nLeafCount = intPointer.value;
                        }
                    }
                }
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    void AddColor(NodePointer nodePointer, int n, int n2, int n3, int n4, int n5, int n6, IntPointer intPointer, NODE[] nODEArray) {
        short[] sArray = new short[]{128, 64, 32, 16, 8, 4, 2, 1};
        if (nodePointer.value == null) {
            nodePointer.value = this.CreateNode(n6, n5, intPointer, nODEArray);
        }
        if (nodePointer.value.bIsLeaf) {
            ++nodePointer.value.nPixelCount;
            nodePointer.value.nRedSum += n;
            nodePointer.value.nGreenSum += n2;
            nodePointer.value.nBlueSum += n3;
            nodePointer.value.nAlphaSum += n4;
        } else {
            int n7 = 7 - n6;
            int n8 = (n & sArray[n6]) >> n7 << 2 | (n2 & sArray[n6]) >> n7 << 1 | (n3 & sArray[n6]) >> n7;
            NodePointer nodePointer2 = new NodePointer(nodePointer.value.pChild[n8]);
            this.AddColor(nodePointer2, n, n2, n3, n4, n5, n6 + 1, intPointer, nODEArray);
            nodePointer.value.pChild[n8] = nodePointer2.value;
        }
    }

    NODE CreateNode(int n, int n2, IntPointer intPointer, NODE[] nODEArray) {
        NODE nODE = new NODE();
        if (nODE == null) {
            return null;
        }
        boolean bl = nODE.bIsLeaf = n == n2;
        if (nODE.bIsLeaf) {
            ++intPointer.value;
        } else {
            nODE.pNext = nODEArray[n];
            nODEArray[n] = nODE;
        }
        return nODE;
    }

    void ReduceTree(int n, IntPointer intPointer, NODE[] nODEArray) {
        int n2;
        for (n2 = n - 1; n2 > 0 && nODEArray[n2] == null; --n2) {
        }
        NODE nODE = nODEArray[n2];
        nODEArray[n2] = nODE.pNext;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        for (n2 = 0; n2 < 8; ++n2) {
            if (nODE.pChild[n2] == null) continue;
            n3 += nODE.pChild[n2].nRedSum;
            n4 += nODE.pChild[n2].nGreenSum;
            n5 += nODE.pChild[n2].nBlueSum;
            n6 += nODE.pChild[n2].nAlphaSum;
            nODE.nPixelCount += nODE.pChild[n2].nPixelCount;
            nODE.pChild[n2] = null;
            ++n7;
        }
        nODE.bIsLeaf = true;
        nODE.nRedSum = n3;
        nODE.nGreenSum = n4;
        nODE.nBlueSum = n5;
        nODE.nAlphaSum = n6;
        intPointer.value -= n7 - 1;
    }

    void DeleteTree(NodePointer nodePointer) {
        nodePointer.value = null;
    }

    void GetPaletteColors(NODE nODE, RGBQUAD[] rGBQUADArray, IntPointer intPointer, int[] nArray) {
        if (nODE != null) {
            if (nODE.bIsLeaf) {
                rGBQUADArray[intPointer.value].rgbRed = (short)(nODE.nRedSum / nODE.nPixelCount);
                rGBQUADArray[intPointer.value].rgbGreen = (short)(nODE.nGreenSum / nODE.nPixelCount);
                rGBQUADArray[intPointer.value].rgbBlue = (short)(nODE.nBlueSum / nODE.nPixelCount);
                rGBQUADArray[intPointer.value].rgbReserved = (short)(nODE.nAlphaSum / nODE.nPixelCount);
                if (nArray != null) {
                    nArray[intPointer.value] = nODE.nPixelCount;
                }
                ++intPointer.value;
            } else {
                for (int i = 0; i < 8; ++i) {
                    if (nODE.pChild[i] == null) continue;
                    this.GetPaletteColors(nODE.pChild[i], rGBQUADArray, intPointer, nArray);
                }
            }
        }
    }

    int GetColorCount() {
        return this.m_nLeafCount;
    }

    public void SetColorTable(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        int n = 0;
        if (this.m_nOutputMaxColors < 16) {
            int n2;
            int[] nArray = new int[16];
            RGBQUAD[] rGBQUADArray = new RGBQUAD[16];
            for (n2 = 0; n2 < rGBQUADArray.length; ++n2) {
                rGBQUADArray[n2] = new RGBQUAD();
            }
            IntPointer intPointer = new IntPointer(n);
            this.GetPaletteColors(this.m_pTree, rGBQUADArray, intPointer, nArray);
            n = intPointer.value;
            if (this.m_nLeafCount > this.m_nOutputMaxColors) {
                for (int i = 0; i < this.m_nOutputMaxColors; ++i) {
                    int n3 = i * this.m_nLeafCount / this.m_nOutputMaxColors;
                    int n4 = (i + 1) * this.m_nLeafCount / this.m_nOutputMaxColors;
                    int n5 = 0;
                    int n6 = 0;
                    int n7 = 0;
                    int n8 = 0;
                    int n9 = 0;
                    for (int j = n3; j < n4; ++j) {
                        n9 += rGBQUADArray[j].rgbRed * nArray[j];
                        n8 += rGBQUADArray[j].rgbGreen * nArray[j];
                        n7 += rGBQUADArray[j].rgbBlue * nArray[j];
                        n6 += rGBQUADArray[j].rgbReserved * nArray[j];
                        n5 += nArray[j];
                    }
                    n2 = n9 / n5;
                    byArray[i] = (byte)(n2 < 128 ? n2 : 254 - n2);
                    n2 = n8 / n5;
                    byArray2[i] = (byte)(n2 < 128 ? n2 : 254 - n2);
                    n2 = n7 / n5;
                    byArray3[i] = (byte)(n2 < 128 ? n2 : 254 - n2);
                }
            } else {
                for (int i = 0; i < this.m_nLeafCount; ++i) {
                    byArray[i] = (byte)rGBQUADArray[i].rgbRed;
                    byArray2[i] = (byte)rGBQUADArray[i].rgbGreen;
                    byArray3[i] = (byte)rGBQUADArray[i].rgbBlue;
                }
            }
        } else {
            int n10;
            IntPointer intPointer = new IntPointer(n);
            RGBQUAD[] rGBQUADArray = new RGBQUAD[byArray.length];
            for (n10 = 0; n10 < rGBQUADArray.length; ++n10) {
                rGBQUADArray[n10] = new RGBQUAD();
            }
            this.GetPaletteColors(this.m_pTree, rGBQUADArray, intPointer, null);
            n = intPointer.value;
            for (n10 = 0; n10 < this.m_nLeafCount; ++n10) {
                byArray[n10] = (byte)rGBQUADArray[n10].rgbRed;
                byArray2[n10] = (byte)rGBQUADArray[n10].rgbGreen;
                byArray3[n10] = (byte)rGBQUADArray[n10].rgbBlue;
            }
        }
    }

    int GetPixelIndex(int n, int n2, int n3, int n4, int[] nArray) {
        if (n3 == 8) {
            return nArray[n2 * n4 + n];
        }
        int n5 = nArray[n2 * n4 + (n * n3 >> 3)];
        if (n3 == 4) {
            int n6 = 4 * (1 - n % 2);
            return (n5 &= 15 << n6) >> n6;
        }
        if (n3 == 1) {
            int n7 = 7 - n % 8;
            return (n5 &= 1 << n7) >> n7;
        }
        return 0;
    }

    protected static class IntPointer {
        public int value;

        public IntPointer(int n) {
            this.value = n;
        }
    }

    protected static class NodePointer {
        public NODE value;

        public NodePointer(NODE nODE) {
            this.value = nODE;
        }
    }

    protected static class NODE {
        public boolean bIsLeaf;
        public int nPixelCount;
        public int nRedSum;
        public int nGreenSum;
        public int nBlueSum;
        public int nAlphaSum;
        public NODE[] pChild = new NODE[8];
        public NODE pNext;

        NODE() {
        }
    }

    protected static class RGBQUAD {
        public int rgbBlue;
        public int rgbGreen;
        public int rgbRed;
        public int rgbReserved;

        protected RGBQUAD() {
        }
    }
}

