/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model;

import charactermanaj.model.ColorGroup;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Layer
implements Comparable<Layer>,
Serializable {
    private static final long serialVersionUID = -6437516046486547811L;
    private final int order;
    private final String id;
    private final String localizedName;
    private final ColorGroup colorGroup;
    private final boolean initSync;
    private final String dir;

    public Layer(String string, String string2, int n, ColorGroup colorGroup, boolean bl, String string3) {
        if (string == null || string.length() == 0 || n < 0 || string3 == null) {
            throw new IllegalArgumentException();
        }
        if (string2 == null || string2.length() == 0) {
            string2 = string;
        }
        if (colorGroup == null) {
            colorGroup = ColorGroup.NA;
        }
        this.id = string;
        this.localizedName = string2;
        this.order = n;
        this.colorGroup = colorGroup;
        this.initSync = bl;
        this.dir = string3;
    }

    @Override
    public int compareTo(Layer layer) {
        int n = this.order - layer.order;
        if (n == 0) {
            n = this.id.compareTo(layer.id);
        }
        if (n == 0) {
            n = this.dir.compareTo(layer.dir);
        }
        return n;
    }

    public String getId() {
        return this.id;
    }

    public String getLocalizedName() {
        return this.localizedName;
    }

    public int getOrder() {
        return this.order;
    }

    public ColorGroup getColorGroup() {
        return this.colorGroup;
    }

    public boolean isInitSync() {
        return this.initSync;
    }

    public String getDir() {
        return this.dir;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object instanceof Layer) {
            Layer layer = (Layer)object;
            return this.id.equals(layer.id) && this.order == layer.order && this.dir.equals(layer.dir);
        }
        return false;
    }

    public static boolean equals(Layer layer, Layer layer2) {
        if (layer == layer2) {
            return true;
        }
        if (layer == null || layer2 == null) {
            return false;
        }
        return layer.equals(layer2);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return "Layer(id=" + this.id + ", name=" + this.localizedName + ", order=" + this.order + ")";
    }
}

