/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model;

import charactermanaj.model.Layer;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PartsCategory
implements Comparable<PartsCategory>,
Serializable {
    private static final long serialVersionUID = -8652242530280056201L;
    private final int order;
    private final String categoryId;
    private final String localizedCategoryName;
    private final boolean multipleSelectable;
    private final int visibleRows;
    private final List<Layer> layers;

    public PartsCategory(int n, String string, String string2, boolean bl, int n2, Layer[] layerArray) {
        if (string == null || string.trim().length() == 0) {
            throw new IllegalArgumentException();
        }
        if (layerArray == null) {
            layerArray = new Layer[]{};
        }
        if (string2 == null || string2.trim().length() == 0) {
            string2 = string;
        }
        this.order = n;
        this.categoryId = string.trim();
        this.localizedCategoryName = string2.trim();
        this.multipleSelectable = bl;
        this.layers = Collections.unmodifiableList(Arrays.asList((Object[])layerArray.clone()));
        this.visibleRows = n2;
    }

    @Override
    public int compareTo(PartsCategory partsCategory) {
        if (partsCategory == this) {
            return 0;
        }
        int n = this.order - partsCategory.getOrder();
        if (n == 0) {
            n = this.localizedCategoryName.compareTo(this.localizedCategoryName);
        }
        if (n == 0) {
            n = this.categoryId.compareTo(partsCategory.getCategoryId());
        }
        return n;
    }

    public int hashCode() {
        return this.categoryId.hashCode();
    }

    public boolean equals(Object object) {
        PartsCategory partsCategory;
        if (object == this) {
            return true;
        }
        return object != null && object instanceof PartsCategory && this.categoryId.equals((partsCategory = (PartsCategory)object).getCategoryId()) && this.order == partsCategory.order && this.localizedCategoryName.equals(partsCategory.localizedCategoryName) && this.multipleSelectable == partsCategory.multipleSelectable && this.visibleRows == partsCategory.visibleRows && ((Object)this.layers).equals(partsCategory.layers);
    }

    public static boolean equals(PartsCategory partsCategory, PartsCategory partsCategory2) {
        if (partsCategory == partsCategory2) {
            return true;
        }
        if (partsCategory == null || partsCategory2 == null) {
            return false;
        }
        return partsCategory.equals(partsCategory2);
    }

    public int getOrder() {
        return this.order;
    }

    public boolean isMultipleSelectable() {
        return this.multipleSelectable;
    }

    public int getVisibleRows() {
        return this.visibleRows;
    }

    public boolean hasLayer(Layer layer) {
        if (layer == null) {
            return false;
        }
        for (Layer layer2 : this.layers) {
            if (!Layer.equals(layer2, layer)) continue;
            return true;
        }
        return false;
    }

    public List<Layer> getLayers() {
        return this.layers;
    }

    public Layer getLayer(String string) {
        if (string == null) {
            return null;
        }
        for (Layer layer : this.layers) {
            if (!layer.getId().equals(string)) continue;
            return layer;
        }
        return null;
    }

    public String getCategoryId() {
        return this.categoryId;
    }

    public String getLocalizedCategoryName() {
        return this.localizedCategoryName;
    }

    public String toString() {
        return this.getLocalizedCategoryName();
    }
}

