/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model.io;

import charactermanaj.graphics.io.ImageResource;
import charactermanaj.graphics.io.ImageSaveHelper;
import charactermanaj.model.AppConfig;
import charactermanaj.model.CharacterData;
import charactermanaj.model.Layer;
import charactermanaj.model.PartsFiles;
import charactermanaj.model.PartsIdentifier;
import charactermanaj.model.PartsSpec;
import charactermanaj.model.io.AbstractCharacterDataFileWriter;
import charactermanaj.model.io.CharacterDataPersistent;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCharacterDataArchivedFileWriter
extends AbstractCharacterDataFileWriter {
    protected AbstractCharacterDataArchivedFileWriter(File file) throws IOException {
        super(file);
    }

    protected abstract OutputStream getOutputStream() throws IOException;

    protected abstract void putNextEntry(String var1, long var2) throws IOException;

    protected abstract void closeEntry() throws IOException;

    @Override
    protected void internalWriteExportProp(Properties properties) throws IOException {
        this.putNextEntry("export-info.xml", 0L);
        properties.storeToXML(this.getOutputStream(), "exportProp");
    }

    @Override
    protected void internalWriteCharacterData(CharacterData characterData) throws IOException {
        CharacterDataPersistent characterDataPersistent = CharacterDataPersistent.getInstance();
        this.putNextEntry("character.xml", 0L);
        characterDataPersistent.writeXMLCharacterData(characterData, this.getOutputStream());
        this.closeEntry();
    }

    @Override
    protected void internalWriteTextUTF16LE(String string, String string2) throws IOException {
        if (string2 == null) {
            string2 = "";
        }
        string2 = string2.replace("\r\n", "\n");
        string2 = string2.replace("\r", "\n");
        string2 = string2.replace("\n", "\r\n");
        this.putNextEntry(string, 0L);
        OutputStream outputStream = this.getOutputStream();
        outputStream.write(-1);
        outputStream.write(-2);
        outputStream.flush();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, Charset.forName("UTF-16LE"));
        outputStreamWriter.append(string2);
        outputStreamWriter.flush();
        this.closeEntry();
    }

    @Override
    protected void internalWriteSamplePicture(BufferedImage bufferedImage) throws IOException {
        this.putNextEntry("preview.png", 0L);
        ImageSaveHelper imageSaveHelper = new ImageSaveHelper();
        imageSaveHelper.savePicture(bufferedImage, Color.white, this.getOutputStream(), "image/png", null);
        this.closeEntry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void internalWritePartsImages(Map<PartsIdentifier, PartsSpec> map) throws IOException {
        AppConfig appConfig = AppConfig.getInstance();
        byte[] byArray = new byte[appConfig.getJarTransferBufferSize()];
        for (Map.Entry<PartsIdentifier, PartsSpec> entry : map.entrySet()) {
            PartsIdentifier partsIdentifier = entry.getKey();
            PartsSpec partsSpec = entry.getValue();
            PartsFiles partsFiles = partsSpec.getPartsFiles();
            for (Map.Entry<Layer, ImageResource> entry2 : partsFiles.entrySet()) {
                Layer layer = entry2.getKey();
                ImageResource imageResource = entry2.getValue();
                String string = layer.getDir() + "/" + partsIdentifier.getPartsName() + ".png";
                string = string.replace("//", "/");
                this.putNextEntry(string, imageResource.lastModified());
                OutputStream outputStream = this.getOutputStream();
                InputStream inputStream = imageResource.openStream();
                try {
                    int n;
                    while ((n = inputStream.read(byArray)) >= 0) {
                        outputStream.write(byArray, 0, n);
                    }
                }
                finally {
                    inputStream.close();
                }
                this.closeEntry();
            }
        }
    }
}

