/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model.io;

import charactermanaj.model.AppConfig;
import charactermanaj.model.io.AbstractCharacterDataArchivedFileWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;

public class CharacterDataZipFileWriter
extends AbstractCharacterDataArchivedFileWriter {
    protected ZipOutputStream zipOutStm;
    protected CharsetEncoder enc;
    protected String rootPrefix = "";

    public CharacterDataZipFileWriter(File file) throws IOException {
        super(file);
        AppConfig appConfig = AppConfig.getInstance();
        String string = appConfig.getZipNameEncoding();
        this.zipOutStm = new ZipOutputStream(this.tmpFile);
        this.enc = Charset.forName(string).newEncoder();
        this.zipOutStm.setEncoding(string);
        this.enc.onUnmappableCharacter(CodingErrorAction.REPORT);
        String string2 = file.getName();
        int n = string2.lastIndexOf(46);
        if (n > 0) {
            string2 = string2.substring(0, n);
        }
        this.setRootPrefix(string2);
    }

    public void setRootPrefix(String string) {
        if (string == null || string.trim().equals("/")) {
            string = "";
        }
        if (string.length() > 0 && !string.endsWith("/")) {
            string = string + "/";
        }
        this.rootPrefix = string.trim();
    }

    public String getRootPrefix() {
        return this.rootPrefix;
    }

    protected void closeEntry() throws IOException {
        this.zipOutStm.closeEntry();
    }

    protected OutputStream getOutputStream() throws IOException {
        return this.zipOutStm;
    }

    protected void putNextEntry(String string, long l) throws IOException {
        String string2 = this.rootPrefix + string;
        this.checkName(string2);
        ZipEntry zipEntry = new ZipEntry(string2);
        if (l > 0L) {
            zipEntry.setTime(l);
        }
        this.zipOutStm.putNextEntry(zipEntry);
    }

    protected void internalClose() throws IOException {
        this.zipOutStm.close();
    }

    protected void checkName(String string) throws UnsupportedEncodingException, IOException {
        if (string == null || string.length() == 0) {
            throw new IOException("missing entry name");
        }
        if (!this.enc.canEncode(string)) {
            throw new UnsupportedEncodingException("file name encoding error.: " + string);
        }
    }
}

