/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model.io;

import charactermanaj.model.ColorGroup;
import charactermanaj.model.PartsCategory;
import charactermanaj.model.PartsIdentifier;
import charactermanaj.model.PartsSpec;
import charactermanaj.model.io.PartsDataLoader;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartsSpecDecorateLoader
implements PartsDataLoader {
    private PartsDataLoader parent;
    private Collection<ColorGroup> colorGroups;

    public PartsSpecDecorateLoader(PartsDataLoader partsDataLoader, Collection<ColorGroup> collection) {
        if (partsDataLoader == null) {
            throw new IllegalArgumentException();
        }
        if (collection == null) {
            collection = Collections.emptyList();
        }
        this.parent = partsDataLoader;
        this.colorGroups = collection;
    }

    @Override
    public Map<PartsIdentifier, PartsSpec> load(PartsCategory partsCategory) {
        Map<PartsIdentifier, PartsSpec> map = this.parent.load(partsCategory);
        this.decolatePartsSpec(map);
        return map;
    }

    protected void decolatePartsSpec(Map<PartsIdentifier, PartsSpec> map) {
        for (ColorGroup colorGroup : this.colorGroups) {
            String string = "(" + colorGroup.getLocalizedName() + ")";
            for (PartsSpec partsSpec : map.values()) {
                if (!partsSpec.getPartsIdentifier().getLocalizedPartsName().endsWith(string)) continue;
                partsSpec.setColorGroup(colorGroup);
            }
        }
    }
}

