/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.model.AppConfig;
import charactermanaj.ui.JSysInfoPanel;
import charactermanaj.util.DesktopUtilities;
import charactermanaj.util.ErrorMessageHelper;
import charactermanaj.util.LocalizedResourceTextLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class AboutBox {
    private JFrame parent;

    public AboutBox(JFrame jFrame) {
        if (jFrame == null) {
            throw new IllegalArgumentException();
        }
        this.parent = jFrame;
    }

    public void showAboutBox() {
        final JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.setPreferredSize(new Dimension(400, 300));
        JPanel jPanel = this.createAboutPanel();
        final JSysInfoPanel jSysInfoPanel = this.createSysInfoPanel();
        jTabbedPane.addTab("About", jPanel);
        jTabbedPane.addTab("System", jSysInfoPanel);
        jTabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (jTabbedPane.getSelectedIndex() == 1) {
                    AboutBox.this.gc();
                    jSysInfoPanel.setText(AboutBox.this.getSysInfoText());
                }
            }
        });
        JOptionPane.showMessageDialog(this.parent, jTabbedPane, "About", 1);
    }

    protected JPanel createAboutPanel() {
        String string = LocalizedResourceTextLoader.getInstance().getText("appinfo/about.html", Charset.forName("MS932"));
        JPanel jPanel = new JPanel(new BorderLayout());
        JEditorPane jEditorPane = new JEditorPane();
        jEditorPane.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (hyperlinkEvent.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                    URL uRL = hyperlinkEvent.getURL();
                    try {
                        if (!DesktopUtilities.browse(uRL.toURI())) {
                            JOptionPane.showMessageDialog(AboutBox.this.parent, uRL.toString());
                        }
                    }
                    catch (Exception exception) {
                        ErrorMessageHelper.showErrorDialog(AboutBox.this.parent, exception);
                    }
                }
            }
        });
        jEditorPane.setEditable(false);
        jEditorPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        jEditorPane.setContentType("text/html");
        jEditorPane.setText(string);
        jEditorPane.setSelectionStart(0);
        jEditorPane.setSelectionEnd(0);
        jPanel.add((Component)new JScrollPane(jEditorPane), "Center");
        return jPanel;
    }

    protected JSysInfoPanel createSysInfoPanel() {
        return new JSysInfoPanel();
    }

    protected String getSysInfoText() {
        Map<Object, Object> map;
        Runtime runtime = Runtime.getRuntime();
        this.gc();
        long l = runtime.totalMemory() / 1024L;
        long l2 = runtime.freeMemory() / 1024L;
        long l3 = runtime.maxMemory() / 1024L;
        DecimalFormat decimalFormat = new DecimalFormat("#,###,##0");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        stringBuilder.append("<h2>Runtime Information</h2>");
        stringBuilder.append("<table border=\"0\">");
        stringBuilder.append("<tr><td>Max Memory:</td><td>" + decimalFormat.format(l3) + " KiB</td></tr>");
        stringBuilder.append("<tr><td>Total Memory:</td><td>" + decimalFormat.format(l) + " KiB</td></tr>");
        stringBuilder.append("<tr><td>Free Memory:</td><td>" + decimalFormat.format(l2) + " KiB</td></tr>");
        stringBuilder.append("</table>");
        AppConfig appConfig = AppConfig.getInstance();
        stringBuilder.append("<h2>Character Database</h2>");
        stringBuilder.append("<table border=\"1\">");
        stringBuilder.append("<tr><td>System</td><td>" + appConfig.getSystemCharactersDir() + "</td></tr>");
        stringBuilder.append("<tr><td>User</td><td>" + appConfig.getUserCharactersDir() + "</td></tr>");
        stringBuilder.append("</table>");
        stringBuilder.append("<h2>System Properties</h2><table border=\"1\">");
        try {
            map = System.getProperties();
            Enumeration<Object> enumeration = ((Properties)map).keys();
            TreeMap<Object, String> object = new TreeMap<Object, String>();
            while (enumeration.hasMoreElements()) {
                Object object2;
                String string = ((Properties)map).getProperty((String)(object2 = (String)enumeration.nextElement()));
                object.put(object2, string == null ? "null" : string);
            }
            for (Map.Entry entry : object.entrySet()) {
                stringBuilder.append("<tr>");
                stringBuilder.append("<td>" + this.escape((String)entry.getKey()) + "</td><td>" + this.escape((String)entry.getValue()) + "</td>");
                stringBuilder.append("</tr>");
            }
            stringBuilder.append("</table>");
        }
        catch (Exception exception) {
            stringBuilder.append(this.escape(exception.toString()));
        }
        stringBuilder.append("<h2>System Environments</h2>");
        try {
            map = new TreeMap();
            ((TreeMap)map).putAll(System.getenv());
            stringBuilder.append("<table border=\"1\">");
            for (Map.Entry entry : ((TreeMap)map).entrySet()) {
                stringBuilder.append("<tr>");
                stringBuilder.append("<td>" + this.escape((String)entry.getKey()) + "</td><td>" + this.escape((String)entry.getValue()) + "</td>");
                stringBuilder.append("</tr>");
            }
            stringBuilder.append("</table>");
        }
        catch (Exception exception) {
            stringBuilder.append(this.escape(exception.toString()));
        }
        stringBuilder.append("</html>");
        return stringBuilder.toString();
    }

    protected String escape(String string) {
        if (string == null) {
            return null;
        }
        string = string.replace("&", "&amp;");
        string = string.replace("<", "&lt;");
        string = string.replace(">", "&gt;");
        return string;
    }

    protected void gc() {
        for (int i = 0; i < 3; ++i) {
            System.gc();
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

