/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.ui.AppConfigRowModel;
import charactermanaj.ui.model.AbstractTableModelWithComboBoxModel;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.swing.table.TableColumnModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AppConfigTableModel
extends AbstractTableModelWithComboBoxModel<AppConfigRowModel> {
    private static final long serialVersionUID = 1L;
    private static final String[] COLUMN_NAMES;
    private static final int[] COLUMN_WIDTHS;
    private Properties target = new Properties();
    private Properties original;

    AppConfigTableModel() {
    }

    public void initModel(Properties properties) {
        this.clear();
        this.target.clear();
        this.original = properties;
        if (properties != null) {
            this.target.putAll((Map<?, ?>)properties);
            Properties properties2 = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties("strings/appconfigdialog");
            for (Object object : this.target.keySet()) {
                String string = properties2.getProperty((String)object);
                if (string == null || string.length() == 0) {
                    string = (String)object;
                }
                AppConfigRowModel appConfigRowModel = new AppConfigRowModel(this.target, (String)object, string);
                this.addRow(appConfigRowModel);
            }
        }
        this.sort();
    }

    public void sort() {
        Collections.sort(this.elements);
        this.fireTableDataChanged();
    }

    public void setRejectNames(Set<String> set) {
        for (AppConfigRowModel appConfigRowModel : this.elements) {
            String string = appConfigRowModel.getKey();
            boolean bl = set != null && set.contains(string);
            appConfigRowModel.setRejected(bl);
        }
        this.fireTableDataChanged();
    }

    public boolean isModified() {
        if (this.original == null) {
            return true;
        }
        return !this.original.equals(this.target);
    }

    public Properties getProperties() {
        return this.target;
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return String.class;
    }

    @Override
    public String getColumnName(int n) {
        return COLUMN_NAMES[n];
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 == 1;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        AppConfigRowModel appConfigRowModel = (AppConfigRowModel)this.getRow(n);
        switch (n2) {
            case 0: {
                return appConfigRowModel.getDisplayName();
            }
            case 1: {
                return appConfigRowModel.getValue();
            }
        }
        return "";
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        AppConfigRowModel appConfigRowModel = (AppConfigRowModel)this.getRow(n);
        if (n2 == 1) {
            appConfigRowModel.setValue((String)object);
            this.fireTableCellUpdated(n, n2);
        }
    }

    public void adjustColumnModel(TableColumnModel tableColumnModel) {
        int n = tableColumnModel.getColumnCount();
        for (int i = 0; i < n; ++i) {
            tableColumnModel.getColumn(i).setWidth(COLUMN_WIDTHS[i]);
        }
    }

    static {
        Properties properties = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties("strings/appconfigdialog");
        COLUMN_NAMES = new String[]{properties.getProperty("column.key"), properties.getProperty("column.value")};
        COLUMN_WIDTHS = new int[]{Integer.parseInt(properties.getProperty("column.key.width")), Integer.parseInt(properties.getProperty("column.value.width"))};
    }
}

