/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.model.PartsCategory;
import charactermanaj.model.PartsIdentifier;
import charactermanaj.model.PartsSpec;
import java.sql.Timestamp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ExportPartsSelectModel
implements Comparable<ExportPartsSelectModel> {
    private boolean selected;
    private PartsIdentifier partsIdentifier;
    private PartsSpec partsSpec;
    private Timestamp timestamp;

    public ExportPartsSelectModel(PartsIdentifier partsIdentifier, PartsSpec partsSpec, boolean bl) {
        if (partsIdentifier == null || partsSpec == null) {
            throw new IllegalArgumentException();
        }
        this.partsIdentifier = partsIdentifier;
        this.partsSpec = partsSpec;
        this.selected = bl;
        long l = partsSpec.getPartsFiles().lastModified();
        this.timestamp = l > 0L ? new Timestamp(l) : null;
    }

    @Override
    public int compareTo(ExportPartsSelectModel exportPartsSelectModel) {
        int n = (this.selected ? 0 : 1) - (exportPartsSelectModel.selected ? 0 : 1);
        if (n == 0) {
            n = this.partsIdentifier.compareTo(exportPartsSelectModel.partsIdentifier);
        }
        return n;
    }

    public PartsIdentifier getPartsIdentifier() {
        return this.partsIdentifier;
    }

    public PartsSpec getPartsSpec() {
        return this.partsSpec;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
    }

    public PartsCategory getPartsCategory() {
        return this.partsIdentifier.getPartsCategory();
    }

    public String getPartsName() {
        return this.partsIdentifier.getLocalizedPartsName();
    }

    public Timestamp getTimestamp() {
        return this.timestamp == null ? null : (Timestamp)this.timestamp.clone();
    }
}

