/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.model.PartsIdentifier;
import charactermanaj.model.PartsSet;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ExportPresetModel
implements Comparable<ExportPresetModel> {
    private boolean selected;
    private PartsSet partsSet;
    private List<PartsIdentifier> missingPartsIdentifiers;

    public ExportPresetModel(PartsSet partsSet, boolean bl) {
        if (partsSet == null) {
            throw new IllegalArgumentException();
        }
        this.partsSet = partsSet;
        this.selected = bl;
    }

    @Override
    public int compareTo(ExportPresetModel exportPresetModel) {
        int n = (this.selected ? 0 : 1) - (exportPresetModel.selected ? 0 : 1);
        if (n == 0) {
            n = this.getPartsSetName().compareTo(exportPresetModel.getPartsSetName());
        }
        return n;
    }

    public String getPartsSetName() {
        String string = this.partsSet.getLocalizedName();
        return string == null ? "" : string;
    }

    public boolean isPresetParts() {
        return this.partsSet.isPresetParts();
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
    }

    public PartsSet getPartsSet() {
        return this.partsSet;
    }

    public void setMissingPartsIdentifiers(List<PartsIdentifier> list) {
        this.missingPartsIdentifiers = Collections.unmodifiableList(list);
    }

    public List<PartsIdentifier> getMissingPartsIdentifiers() {
        if (this.missingPartsIdentifiers == null) {
            return Collections.emptyList();
        }
        return this.missingPartsIdentifiers;
    }
}

