/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.model.AppConfig;
import charactermanaj.model.PartsIdentifier;
import charactermanaj.model.PartsSet;
import charactermanaj.ui.AbstractImportPanel;
import charactermanaj.ui.ExportInformationResolver;
import charactermanaj.ui.ExportPartsResolver;
import charactermanaj.ui.ExportPresetModel;
import charactermanaj.ui.ExportPresetResolve;
import charactermanaj.ui.ExportPresetTableModel;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ExportPresetSelectPanel
extends AbstractImportPanel
implements ExportPresetResolve {
    private static final long serialVersionUID = 1L;
    private ExportPartsResolver exportPartsResolver;
    private ExportPresetTableModel presetTableModel;
    private JTable presetTable;
    private Action actSelectAll;
    private Action actDeselectAll;

    protected ExportPresetSelectPanel(ExportPartsResolver exportPartsResolver, final ExportInformationResolver exportInformationResolver, Collection<PartsSet> collection, String string) {
        this.exportPartsResolver = exportPartsResolver;
        this.setName("presetSelectPanel");
        Properties properties = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties("strings/exportwizdialog");
        this.setName("choosePartsPanel");
        this.setBorder(BorderFactory.createTitledBorder(properties.getProperty("preset.title")));
        this.setLayout(new BorderLayout());
        this.presetTableModel = new ExportPresetTableModel();
        this.presetTableModel.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                if (tableModelEvent.getType() == 0) {
                    ExportPresetSelectPanel.this.fireChangeEvent();
                }
            }
        });
        exportPartsResolver.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ExportPresetSelectPanel.this.checkMissingParts();
            }
        });
        this.loadPresetInfo(collection, string);
        AppConfig appConfig = AppConfig.getInstance();
        final Color color = appConfig.getExportPresetWarningsForegroundColor();
        final Color color2 = appConfig.getDisabledCellForgroundColor();
        this.presetTable = new JTable(this.presetTableModel){
            private static final long serialVersionUID = 1L;

            public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
                ExportPresetModel exportPresetModel;
                Component component = super.prepareRenderer(tableCellRenderer, n, n2);
                if (component instanceof JCheckBox) {
                    component.setEnabled(this.isCellEditable(n, n2) && this.isEnabled());
                }
                if ((exportPresetModel = (ExportPresetModel)ExportPresetSelectPanel.this.presetTableModel.getRow(n)).isPresetParts()) {
                    component.setFont(this.getFont().deriveFont(1));
                } else {
                    component.setFont(this.getFont());
                }
                if (!this.isEnabled()) {
                    component.setForeground(color2);
                } else if (exportPresetModel.isSelected() && exportPresetModel.getMissingPartsIdentifiers().size() > 0) {
                    component.setForeground(color);
                } else {
                    component.setForeground(this.getForeground());
                }
                return component;
            }
        };
        this.presetTable.setShowGrid(true);
        this.presetTable.setGridColor(appConfig.getGridColor());
        final AbstractAction abstractAction = new AbstractAction(properties.getProperty("preset.popup.selectUsedParts")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                ExportPresetSelectPanel.this.exportUsedParts();
            }
        };
        final JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(abstractAction);
        this.presetTable.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                this.evaluatePopup(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.evaluatePopup(mouseEvent);
            }

            private void evaluatePopup(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    abstractAction.setEnabled(exportInformationResolver.isExportPartsImages());
                    jPopupMenu.show(ExportPresetSelectPanel.this.presetTable, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        this.presetTable.setAutoResizeMode(0);
        this.presetTableModel.adjustColumnModel(this.presetTable.getColumnModel());
        this.add((Component)new JScrollPane(this.presetTable), "Center");
        this.actSelectAll = new AbstractAction(properties.getProperty("parts.btn.selectAll")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                ExportPresetSelectPanel.this.onSelectAll();
            }
        };
        this.actDeselectAll = new AbstractAction(properties.getProperty("parts.btn.deselectAll")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                ExportPresetSelectPanel.this.onDeselectAll();
            }
        };
        AbstractAction abstractAction2 = new AbstractAction(properties.getProperty("parts.btn.sort")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                ExportPresetSelectPanel.this.onSort();
            }
        };
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        JButton jButton = new JButton(this.actSelectAll);
        jPanel.add((Component)jButton, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        JButton jButton2 = new JButton(this.actDeselectAll);
        jPanel.add((Component)jButton2, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        JButton jButton3 = new JButton(abstractAction2);
        jPanel.add((Component)jButton3, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        jPanel.add(Box.createHorizontalGlue(), gridBagConstraints);
        this.add((Component)jPanel, "South");
    }

    protected void loadPresetInfo(Collection<PartsSet> collection, String string) {
        this.presetTableModel.clear();
        for (PartsSet partsSet : collection) {
            PartsSet partsSet2 = partsSet.clone();
            ExportPresetModel exportPresetModel = new ExportPresetModel(partsSet2, partsSet2.isPresetParts());
            this.presetTableModel.addRow(exportPresetModel);
        }
        this.presetTableModel.setDefaultPresetId(string);
        this.presetTableModel.sort();
        this.checkMissingParts();
    }

    public void checkMissingParts() {
        ArrayList<PartsSet> arrayList = new ArrayList<PartsSet>();
        HashMap<PartsSet, Object> hashMap = new HashMap<PartsSet, Object>();
        int n = this.presetTableModel.getRowCount();
        for (int i = 0; i < n; ++i) {
            ExportPresetModel exportPresetModel = (ExportPresetModel)this.presetTableModel.getRow(i);
            PartsSet object = exportPresetModel.getPartsSet();
            hashMap.put(object, exportPresetModel);
            arrayList.add(object);
        }
        Map<PartsSet, List<PartsIdentifier>> map = this.exportPartsResolver.checkMissingPartsList(arrayList);
        for (Map.Entry entry : map.entrySet()) {
            PartsSet partsSet = (PartsSet)entry.getKey();
            List list = (List)entry.getValue();
            ExportPresetModel exportPresetModel = (ExportPresetModel)hashMap.get(partsSet);
            exportPresetModel.setMissingPartsIdentifiers(list);
        }
        if (!map.isEmpty()) {
            this.presetTableModel.fireTableDataChanged();
        }
    }

    protected void onSelectAll() {
        this.presetTableModel.selectAll();
    }

    protected void onDeselectAll() {
        this.presetTableModel.deselectAll();
    }

    protected void onSort() {
        this.presetTableModel.sort();
        if (this.presetTableModel.getRowCount() > 0) {
            Rectangle rectangle = this.presetTable.getCellRect(0, 0, true);
            this.presetTable.scrollRectToVisible(rectangle);
        }
    }

    @Override
    public List<PartsSet> getSelectedPresets() {
        return this.presetTableModel.getSelectedPresets();
    }

    protected void exportUsedParts() {
        int[] nArray;
        ArrayList<PartsSet> arrayList = new ArrayList<PartsSet>();
        for (int n : nArray = this.presetTable.getSelectedRows()) {
            ExportPresetModel exportPresetModel = (ExportPresetModel)this.presetTableModel.getRow(n);
            arrayList.add(exportPresetModel.getPartsSet());
        }
        this.exportPartsResolver.selectByPartsSet(arrayList);
    }

    @Override
    public int getSelectedCount() {
        return this.presetTableModel.getSelectedCount();
    }

    public String getDefaultPresetId() {
        return this.presetTableModel.getDefaultPresetId();
    }

    @Override
    public void setEnabled(boolean bl) {
        this.presetTable.setEnabled(bl);
        this.presetTableModel.setEnabled(bl);
        this.actSelectAll.setEnabled(bl);
        this.actDeselectAll.setEnabled(bl);
        super.setEnabled(bl);
    }
}

