/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.model.CharacterData;
import charactermanaj.model.io.AbstractCharacterDataArchiveFile;
import charactermanaj.model.io.CharacterDataArchiveFile;
import charactermanaj.model.io.CharacterDataFileReaderWriterFactory;
import charactermanaj.ui.ArchiveFileDialog;
import charactermanaj.ui.ImportWizardCardPanel;
import charactermanaj.ui.ImportWizardDialog;
import charactermanaj.util.ErrorMessageHelper;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ImportFileSelectPanel
extends ImportWizardCardPanel {
    private static final long serialVersionUID = 1L;
    public static final String PANEL_NAME = "fileSelectPanel";
    private static ArchiveFileDialog archiveFileDialog = new ArchiveFileDialog();
    private ImportWizardDialog parent;
    private JTextField txtFile;
    private File file;
    private CharacterDataArchiveFile archiveFile;
    private CharacterData characterData;
    private BufferedImage samplePicture;
    private String readme;
    private Properties exportInfoProp;
    private Collection<AbstractCharacterDataArchiveFile.PartsImageContent> partsImageContentsMapForCurrentProfile;
    private Collection<AbstractCharacterDataArchiveFile.PartsImageContent> partsImageContentsMapForNewProfile;

    public ImportFileSelectPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        Properties properties = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties("strings/importwizdialog");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.txtFile = new JTextField();
        this.txtFile.getDocument().addDocumentListener(new DocumentListener(){

            public void removeUpdate(DocumentEvent documentEvent) {
                this.fireEvent();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                this.fireEvent();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                this.fireEvent();
            }

            protected void fireEvent() {
                ImportFileSelectPanel.this.fireChangeEvent();
            }
        });
        AbstractAction abstractAction = new AbstractAction(properties.getProperty("browse")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                ImportFileSelectPanel.this.onChooseFile();
            }
        };
        JPanel jPanel = new JPanel(new BorderLayout(3, 3));
        jPanel.setBorder(BorderFactory.createTitledBorder(properties.getProperty("importingArchiveFile")));
        jPanel.add((Component)new JLabel(properties.getProperty("file"), 4), "West");
        jPanel.add((Component)this.txtFile, "Center");
        jPanel.add((Component)new JButton(abstractAction), "East");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        this.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add(Box.createVerticalGlue(), gridBagConstraints);
    }

    protected void onChooseFile() {
        File file;
        File file2 = null;
        if (this.txtFile.getText().trim().length() > 0) {
            file2 = new File(this.txtFile.getText());
        }
        if ((file = archiveFileDialog.showOpenDialog(this, file2)) != null) {
            this.txtFile.setText(file.getPath());
            this.fireChangeEvent();
        }
    }

    @Override
    public boolean isReadyNext() {
        String string = this.txtFile.getText();
        return string != null && string.trim().length() > 0;
    }

    @Override
    public void onActive(ImportWizardDialog importWizardDialog, ImportWizardCardPanel importWizardCardPanel) {
        this.parent = importWizardDialog;
        this.closeArchive();
        this.file = null;
        this.archiveFile = null;
        this.characterData = null;
        this.exportInfoProp = null;
        this.samplePicture = null;
        this.readme = null;
        this.partsImageContentsMapForCurrentProfile = null;
        this.partsImageContentsMapForNewProfile = null;
    }

    public void closeArchive() {
        if (this.archiveFile != null) {
            try {
                this.archiveFile.close();
            }
            catch (IOException iOException) {
                ErrorMessageHelper.showErrorDialog(this, iOException);
            }
            this.archiveFile = null;
        }
    }

    @Override
    public String doNext() {
        if (!this.isReadyNext()) {
            return null;
        }
        File file = new File(this.txtFile.getText());
        if (!file.exists()) {
            JOptionPane.showMessageDialog(this, "\u30d5\u30a1\u30a4\u30eb\u304c\u3042\u308a\u307e\u305b\u3093\u3002", "ERROR", 0);
            return null;
        }
        try {
            CharacterDataFileReaderWriterFactory characterDataFileReaderWriterFactory = CharacterDataFileReaderWriterFactory.getInstance();
            this.file = file;
            this.archiveFile = characterDataFileReaderWriterFactory.openArchive(file);
            this.readme = this.archiveFile.readReadMe();
            this.characterData = this.archiveFile.readCharacterData();
            if (this.characterData == null) {
                this.characterData = this.archiveFile.readCharacterINI();
                if (this.characterData != null) {
                    this.exportInfoProp = new Properties();
                    this.exportInfoProp.setProperty("EXPORT_SUBSET", "false");
                    this.exportInfoProp.setProperty("EXPORT_PRESETS", "true");
                    this.exportInfoProp.setProperty("EXPORT_PARTS_IMAGES", "true");
                    if (this.readme != null && this.readme.trim().length() > 0) {
                        this.characterData.setDescription(this.readme);
                    }
                } else {
                    this.exportInfoProp = null;
                }
            } else {
                this.exportInfoProp = this.archiveFile.readExportProp();
            }
            this.samplePicture = this.archiveFile.readSamplePicture();
            this.partsImageContentsMapForCurrentProfile = this.archiveFile.getPartsImageContents(this.parent.current);
            this.partsImageContentsMapForNewProfile = this.archiveFile.getPartsImageContents(this.characterData);
            return "importTypeSelectPanel";
        }
        catch (Exception exception) {
            ErrorMessageHelper.showErrorDialog(this, exception);
            return null;
        }
    }

    public File getFile() {
        return this.file;
    }

    public CharacterDataArchiveFile getArchiveFile() {
        return this.archiveFile;
    }

    public CharacterData getCharacterData() {
        return this.characterData;
    }

    public BufferedImage getSamplePicture() {
        return this.samplePicture;
    }

    public String getReadme() {
        return this.readme;
    }

    public Properties getExportInfoProp() {
        return this.exportInfoProp;
    }

    public Collection<AbstractCharacterDataArchiveFile.PartsImageContent> getPartsImageContentsForCurrentProfile() {
        return this.partsImageContentsMapForCurrentProfile;
    }

    public Collection<AbstractCharacterDataArchiveFile.PartsImageContent> getPartsImageContentsForNewProfile() {
        return this.partsImageContentsMapForNewProfile;
    }
}

