/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.model.AppConfig;
import charactermanaj.model.CharacterData;
import charactermanaj.model.PartsIdentifier;
import charactermanaj.model.PartsSet;
import charactermanaj.ui.ImportPresetModel;
import charactermanaj.ui.ImportPresetTableModel;
import charactermanaj.ui.ImportWizardCardPanel;
import charactermanaj.ui.ImportWizardDialog;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ImportPresetSelectPanel
extends ImportWizardCardPanel {
    private static final long serialVersionUID = 1L;
    public static final String PANEL_NAME = "importPresetSelectPanel";
    private ImportPresetTableModel presetTableModel;
    private ImportWizardDialog parent;
    private JTable presetTable;
    private Action actSelectAll;
    private Action actDeselectAll;
    private Action actSelectUsedParts;

    public ImportPresetSelectPanel() {
        Properties properties = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties("strings/importwizdialog");
        this.setBorder(BorderFactory.createTitledBorder(properties.getProperty("preset.title")));
        this.setLayout(new BorderLayout());
        this.presetTableModel = new ImportPresetTableModel();
        this.presetTableModel.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                if (tableModelEvent.getType() == 0) {
                    ImportPresetSelectPanel.this.fireChangeEvent();
                }
            }
        });
        AppConfig appConfig = AppConfig.getInstance();
        final Color color = appConfig.getExportPresetWarningsForegroundColor();
        final Color color2 = appConfig.getDisabledCellForgroundColor();
        this.presetTable = new JTable(this.presetTableModel){
            private static final long serialVersionUID = 1L;

            public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
                ImportPresetModel importPresetModel;
                Component component = super.prepareRenderer(tableCellRenderer, n, n2);
                if (component instanceof JCheckBox) {
                    component.setEnabled(this.isCellEditable(n, n2) && this.isEnabled());
                }
                if ((importPresetModel = (ImportPresetModel)ImportPresetSelectPanel.this.presetTableModel.getRow(n)).isOverwrite() || ImportPresetSelectPanel.this.presetTableModel.isDefaultPartsSet(n)) {
                    component.setFont(this.getFont().deriveFont(1));
                } else {
                    component.setFont(this.getFont());
                }
                if (!this.isEnabled()) {
                    component.setForeground(color2);
                } else if (importPresetModel.isCheched() && importPresetModel.getMissingPartsIdentifiers().size() > 0) {
                    component.setForeground(color);
                } else {
                    component.setForeground(this.getForeground());
                }
                return component;
            }
        };
        this.presetTable.setShowGrid(true);
        this.presetTable.setGridColor(appConfig.getGridColor());
        this.actSelectUsedParts = new AbstractAction(properties.getProperty("preset.popup.selectUsedParts")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                ImportPresetSelectPanel.this.exportUsedParts();
            }
        };
        final JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(this.actSelectUsedParts);
        this.presetTable.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                this.evaluatePopup(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.evaluatePopup(mouseEvent);
            }

            private void evaluatePopup(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    jPopupMenu.show(ImportPresetSelectPanel.this.presetTable, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        this.presetTable.setAutoResizeMode(0);
        this.presetTableModel.adjustColumnModel(this.presetTable.getColumnModel());
        this.add((Component)new JScrollPane(this.presetTable), "Center");
        this.actSelectAll = new AbstractAction(properties.getProperty("parts.btn.selectAll")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                ImportPresetSelectPanel.this.onSelectAll();
            }
        };
        this.actDeselectAll = new AbstractAction(properties.getProperty("parts.btn.deselectAll")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                ImportPresetSelectPanel.this.onDeselectAll();
            }
        };
        AbstractAction abstractAction = new AbstractAction(properties.getProperty("parts.btn.sort")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                ImportPresetSelectPanel.this.onSort();
            }
        };
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        JButton jButton = new JButton(this.actSelectAll);
        jPanel.add((Component)jButton, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        JButton jButton2 = new JButton(this.actDeselectAll);
        jPanel.add((Component)jButton2, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        JButton jButton3 = new JButton(abstractAction);
        jPanel.add((Component)jButton3, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        jPanel.add(Box.createHorizontalGlue(), gridBagConstraints);
        this.add((Component)jPanel, "South");
    }

    @Override
    public void onActive(ImportWizardDialog importWizardDialog, ImportWizardCardPanel importWizardCardPanel) {
        this.parent = importWizardDialog;
        this.actSelectUsedParts.setEnabled(importWizardDialog.importTypeSelectPanel.isImportPartsImages());
        this.checkMissingParts();
    }

    public void checkMissingParts() {
        Collection<PartsIdentifier> collection = this.parent.importPartsSelectPanel.getImportedPartsIdentifiers();
        this.presetTableModel.checkMissingParts(collection);
    }

    protected void onSelectAll() {
        this.presetTableModel.selectAll();
    }

    protected void onDeselectAll() {
        this.presetTableModel.deselectAll();
    }

    protected void onSort() {
        this.presetTableModel.sort();
        if (this.presetTableModel.getRowCount() > 0) {
            Rectangle rectangle = this.presetTable.getCellRect(0, 0, true);
            this.presetTable.scrollRectToVisible(rectangle);
        }
    }

    protected void exportUsedParts() {
        int[] nArray;
        ArrayList<PartsIdentifier> arrayList = new ArrayList<PartsIdentifier>();
        for (int n : nArray = this.presetTable.getSelectedRows()) {
            ImportPresetModel importPresetModel = (ImportPresetModel)this.presetTableModel.getRow(n);
            PartsSet partsSet = importPresetModel.getPartsSet();
            for (List list : partsSet.values()) {
                for (PartsIdentifier partsIdentifier : list) {
                    arrayList.add(partsIdentifier);
                }
            }
        }
        this.parent.importPartsSelectPanel.selectByPartsIdentifiers(arrayList);
        this.checkMissingParts();
    }

    @Override
    public boolean isReadyPrevious() {
        return true;
    }

    @Override
    public boolean isReadyNext() {
        return false;
    }

    @Override
    public boolean isReadyFinish() {
        return this.parent != null;
    }

    @Override
    public String doPrevious() {
        return "importPartsSelectPanel";
    }

    @Override
    public String doNext() {
        return null;
    }

    public Collection<PartsSet> getSelectedPartsSets() {
        return this.presetTableModel.getSelectedPartsSets();
    }

    public String getPrefferedDefaultPartsSetId() {
        String string = this.presetTableModel.getDefaultPartsSetId();
        String string2 = null;
        boolean bl = false;
        for (PartsSet partsSet : this.getSelectedPartsSets()) {
            if (string2 == null) {
                string2 = partsSet.getPartsSetId();
            }
            if (!partsSet.getPartsSetId().equals(string)) continue;
            bl = true;
        }
        if (!bl || string == null || string.length() == 0) {
            string = string2;
        }
        return string;
    }

    public void initModel(Collection<PartsSet> collection, String string, CharacterData characterData) {
        this.presetTableModel.initModel(collection, string, characterData);
    }
}

