/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.model.CharacterData;
import charactermanaj.model.PartsIdentifier;
import charactermanaj.model.PartsSet;
import charactermanaj.ui.ImportPresetModel;
import charactermanaj.ui.model.AbstractTableModelWithComboBoxModel;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Properties;
import javax.swing.table.TableColumnModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ImportPresetTableModel
extends AbstractTableModelWithComboBoxModel<ImportPresetModel> {
    private static final long serialVersionUID = 1L;
    private static final String[] COLUMN_NAMES;
    private static final int[] COLUMN_WIDTHS;
    private String defaultPartsSetId;

    ImportPresetTableModel() {
    }

    public String getDefaultPartsSetId() {
        return this.defaultPartsSetId;
    }

    public void setDefaultPartsSetId(String string) {
        this.defaultPartsSetId = string;
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public String getColumnName(int n) {
        return COLUMN_NAMES[n];
    }

    @Override
    public Class<?> getColumnClass(int n) {
        switch (n) {
            case 0: {
                return Boolean.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 == 0 || n2 == 1;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        ImportPresetModel importPresetModel = (ImportPresetModel)this.getRow(n);
        switch (n2) {
            case 0: {
                return importPresetModel.isCheched();
            }
            case 1: {
                return importPresetModel.getPartsSetName();
            }
            case 2: {
                return this.getMissingPartsIdentifiersString(importPresetModel);
            }
        }
        return "";
    }

    private String getMissingPartsIdentifiersString(ImportPresetModel importPresetModel) {
        StringBuilder stringBuilder = new StringBuilder();
        for (PartsIdentifier partsIdentifier : importPresetModel.getMissingPartsIdentifiers()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(partsIdentifier.getLocalizedPartsName());
        }
        return stringBuilder.toString();
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        ImportPresetModel importPresetModel = (ImportPresetModel)this.getRow(n);
        switch (n2) {
            case 0: {
                importPresetModel.setCheched((Boolean)object);
                break;
            }
            case 1: {
                String string = (String)object;
                String string2 = string = string != null ? string.trim() : "";
                if (string.length() > 0) {
                    importPresetModel.setPartsSetName(string);
                }
            }
            default: {
                return;
            }
        }
        this.fireTableRowsUpdated(n, n);
    }

    public boolean isDefaultPartsSet(int n) {
        ImportPresetModel importPresetModel = (ImportPresetModel)this.getRow(n);
        return importPresetModel.getPartsSet().getPartsSetId().equals(this.defaultPartsSetId);
    }

    public void adjustColumnModel(TableColumnModel tableColumnModel) {
        int n = tableColumnModel.getColumnCount();
        for (int i = 0; i < n; ++i) {
            tableColumnModel.getColumn(i).setWidth(COLUMN_WIDTHS[i]);
        }
    }

    public void initModel(Collection<PartsSet> collection, String string, CharacterData characterData) {
        this.clear();
        if (collection == null) {
            return;
        }
        Map<Object, Object> map = characterData != null ? characterData.getPartsSets() : Collections.emptyMap();
        for (PartsSet partsSet : collection) {
            PartsSet partsSet2;
            String string2 = partsSet.getPartsSetId();
            if (string2 == null || string2.length() == 0 || (partsSet2 = characterData != null ? partsSet.createCompatible(characterData) : partsSet).isEmpty()) continue;
            boolean bl = map.containsKey(string2);
            boolean bl2 = characterData == null;
            ImportPresetModel importPresetModel = new ImportPresetModel(partsSet, bl, bl2);
            this.addRow(importPresetModel);
        }
        this.defaultPartsSetId = string;
        this.sort();
    }

    public Collection<PartsSet> getSelectedPartsSets() {
        ArrayList<PartsSet> arrayList = new ArrayList<PartsSet>();
        for (ImportPresetModel importPresetModel : this.elements) {
            if (!importPresetModel.isCheched()) continue;
            arrayList.add(importPresetModel.getPartsSet());
        }
        return arrayList;
    }

    public void selectAll() {
        boolean bl = false;
        for (ImportPresetModel importPresetModel : this.elements) {
            if (importPresetModel.isCheched()) continue;
            importPresetModel.setCheched(true);
            bl = true;
        }
        if (bl) {
            this.fireTableDataChanged();
        }
    }

    public void deselectAll() {
        boolean bl = false;
        for (ImportPresetModel importPresetModel : this.elements) {
            if (!importPresetModel.isCheched()) continue;
            importPresetModel.setCheched(false);
            bl = true;
        }
        if (bl) {
            this.fireTableDataChanged();
        }
    }

    public void sort() {
        Collections.sort(this.elements, new Comparator<ImportPresetModel>(){

            @Override
            public int compare(ImportPresetModel importPresetModel, ImportPresetModel importPresetModel2) {
                int n = (importPresetModel.isCheched() ? 0 : 1) - (importPresetModel2.isCheched() ? 0 : 1);
                if (n == 0) {
                    n = importPresetModel.getPartsSetName().compareTo(importPresetModel2.getPartsSetName());
                }
                return n;
            }
        });
        this.fireTableDataChanged();
    }

    public void checkMissingParts(Collection<PartsIdentifier> collection) {
        boolean bl = false;
        for (ImportPresetModel importPresetModel : this.elements) {
            if (!importPresetModel.checkMissingParts(collection)) continue;
            bl = true;
        }
        if (bl) {
            this.fireTableDataChanged();
        }
    }

    static {
        Properties properties = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties("strings/importwizdialog");
        COLUMN_NAMES = new String[]{properties.getProperty("preset.column.check"), properties.getProperty("preset.column.name"), properties.getProperty("preset.column.missings")};
        COLUMN_WIDTHS = new int[]{Integer.parseInt(properties.getProperty("preset.column.check.size")), Integer.parseInt(properties.getProperty("preset.column.name.size")), Integer.parseInt(properties.getProperty("preset.column.missings.size"))};
    }
}

