/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.Main;
import charactermanaj.model.AppConfig;
import charactermanaj.model.CharacterData;
import charactermanaj.model.PartsSet;
import charactermanaj.model.io.AbstractCharacterDataArchiveFile;
import charactermanaj.model.io.CharacterDataPersistent;
import charactermanaj.ui.ImportFileSelectPanel;
import charactermanaj.ui.ImportPartsSelectPanel;
import charactermanaj.ui.ImportPresetSelectPanel;
import charactermanaj.ui.ImportTypeSelectPanel;
import charactermanaj.ui.ImportWizardCardPanel;
import charactermanaj.util.ErrorMessageHelper;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportWizardDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    protected static final String STRINGS_RESOURCE = "strings/importwizdialog";
    public static final int EXIT_PROFILE_UPDATED = 1;
    public static final int EXIT_PROFILE_CREATED = 2;
    public static final int EXIT_CANCELED = 0;
    private int exitCode = 0;
    private CharacterData importedCharacterData;
    protected CharacterData current;
    protected Collection<CharacterData> profiles;
    private CardLayout mainPanelLayout;
    private ImportWizardCardPanel activePanel;
    private AbstractAction actNext;
    private AbstractAction actPrev;
    private AbstractAction actFinish;
    protected ImportFileSelectPanel fileSelectPanel;
    protected ImportTypeSelectPanel importTypeSelectPanel;
    protected ImportPartsSelectPanel importPartsSelectPanel;
    protected ImportPresetSelectPanel importPresetSelectPanel;

    public ImportWizardDialog(JFrame jFrame, CharacterData characterData) {
        super((Frame)jFrame, true);
        if (characterData == null) {
            throw new IllegalArgumentException();
        }
        this.initComponent(jFrame, characterData, null);
    }

    public ImportWizardDialog(JDialog jDialog, CharacterData characterData, Collection<CharacterData> collection) {
        super((Dialog)jDialog, true);
        if (collection == null) {
            throw new IllegalArgumentException();
        }
        this.initComponent(jDialog, characterData, collection);
    }

    private void initComponent(Component component, CharacterData characterData, Collection<CharacterData> collection) {
        this.current = characterData;
        this.profiles = collection;
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ImportWizardDialog.this.onClose();
            }
        });
        Properties properties = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties(STRINGS_RESOURCE);
        this.setTitle(properties.getProperty("title"));
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        final JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        this.mainPanelLayout = new CardLayout(5, 5);
        jPanel.setLayout(this.mainPanelLayout);
        container.add((Component)jPanel, "Center");
        ChangeListener changeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ImportWizardDialog.this.updateBtnPanelState();
            }
        };
        ComponentAdapter componentAdapter = new ComponentAdapter(){

            public void componentShown(ComponentEvent componentEvent) {
                ImportWizardDialog.this.onComponentShown((ImportWizardCardPanel)componentEvent.getComponent());
            }
        };
        this.actNext = new AbstractAction(properties.getProperty("btn.next")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                ImportWizardDialog.this.setEnableButtons(false);
                String string = ImportWizardDialog.this.doNext();
                if (string != null) {
                    ImportWizardDialog.this.mainPanelLayout.show(jPanel, string);
                } else {
                    ImportWizardDialog.this.updateBtnPanelState();
                }
            }
        };
        this.actPrev = new AbstractAction(properties.getProperty("btn.prev")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                ImportWizardDialog.this.setEnableButtons(false);
                String string = ImportWizardDialog.this.doPrevious();
                if (string != null) {
                    ImportWizardDialog.this.mainPanelLayout.show(jPanel, string);
                } else {
                    ImportWizardDialog.this.updateBtnPanelState();
                }
            }
        };
        this.actFinish = new AbstractAction(properties.getProperty("btn.finish")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                ImportWizardDialog.this.onFinish();
            }
        };
        AbstractAction abstractAction = new AbstractAction(properties.getProperty("btn.cancel")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                ImportWizardDialog.this.onClose();
            }
        };
        this.fileSelectPanel = new ImportFileSelectPanel();
        this.fileSelectPanel.addComponentListener(componentAdapter);
        this.fileSelectPanel.addChangeListener(changeListener);
        jPanel.add((Component)this.fileSelectPanel, "fileSelectPanel");
        this.importTypeSelectPanel = new ImportTypeSelectPanel();
        this.importTypeSelectPanel.addComponentListener(componentAdapter);
        this.importTypeSelectPanel.addChangeListener(changeListener);
        jPanel.add((Component)this.importTypeSelectPanel, "importTypeSelectPanel");
        this.importPartsSelectPanel = new ImportPartsSelectPanel();
        this.importPartsSelectPanel.addComponentListener(componentAdapter);
        this.importPartsSelectPanel.addChangeListener(changeListener);
        jPanel.add((Component)this.importPartsSelectPanel, "importPartsSelectPanel");
        this.importPresetSelectPanel = new ImportPresetSelectPanel();
        this.importPresetSelectPanel.addComponentListener(componentAdapter);
        this.importPresetSelectPanel.addChangeListener(changeListener);
        jPanel.add((Component)this.importPresetSelectPanel, "importPresetSelectPanel");
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 45));
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel2.setLayout(gridBagLayout);
        this.actPrev.setEnabled(false);
        this.actNext.setEnabled(false);
        this.actFinish.setEnabled(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        jPanel2.add(Box.createHorizontalGlue(), gridBagConstraints);
        gridBagConstraints.gridx = Main.isMacOSX() ? 2 : 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        jPanel2.add((Component)new JButton(this.actPrev), gridBagConstraints);
        gridBagConstraints.gridx = Main.isMacOSX() ? 3 : 2;
        gridBagConstraints.gridy = 0;
        JButton jButton = new JButton(this.actNext);
        jPanel2.add((Component)jButton, gridBagConstraints);
        gridBagConstraints.gridx = Main.isMacOSX() ? 4 : 3;
        gridBagConstraints.gridy = 0;
        jPanel2.add((Component)new JButton(this.actFinish), gridBagConstraints);
        gridBagConstraints.gridx = Main.isMacOSX() ? 1 : 4;
        gridBagConstraints.gridy = 0;
        JButton jButton2 = new JButton(abstractAction);
        jPanel2.add((Component)jButton2, gridBagConstraints);
        container.add((Component)jPanel2, "South");
        JRootPane jRootPane = this.getRootPane();
        jRootPane.setDefaultButton(jButton);
        InputMap inputMap = jRootPane.getInputMap(2);
        ActionMap actionMap = jRootPane.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(27, 0), "closeImportWizDialog");
        actionMap.put("closeImportWizDialog", abstractAction);
        this.setSize(500, 500);
        this.setLocationRelativeTo(component);
        this.mainPanelLayout.first(jPanel);
        this.updateBtnPanelState();
    }

    protected void onComponentShown(JPanel jPanel) {
        ImportWizardCardPanel importWizardCardPanel = (ImportWizardCardPanel)jPanel;
        importWizardCardPanel.onActive(this, this.activePanel);
        this.activePanel = importWizardCardPanel;
        this.updateBtnPanelState();
    }

    protected void updateBtnPanelState() {
        if (this.activePanel != null) {
            this.actPrev.setEnabled(this.activePanel.isReadyPrevious());
            this.actNext.setEnabled(this.activePanel.isReadyNext());
            this.actFinish.setEnabled(this.activePanel.isReadyFinish());
        } else {
            this.setEnableButtons(false);
        }
    }

    public void setEnableButtons(boolean bl) {
        this.actPrev.setEnabled(bl);
        this.actNext.setEnabled(bl);
        this.actFinish.setEnabled(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String doNext() {
        String string;
        if (this.activePanel == null) {
            throw new IllegalStateException();
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            string = this.activePanel.doNext();
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
        return string;
    }

    protected String doPrevious() {
        if (this.activePanel == null) {
            throw new IllegalStateException();
        }
        return this.activePanel.doPrevious();
    }

    protected void onClose() {
        Properties properties = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties(STRINGS_RESOURCE);
        if (JOptionPane.showConfirmDialog(this, properties.getProperty("confirm.close"), properties.getProperty("confirm"), 0, 3) != 0) {
            return;
        }
        this.fileSelectPanel.closeArchive();
        this.exitCode = 0;
        this.importedCharacterData = null;
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onFinish() {
        Properties properties = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties(STRINGS_RESOURCE);
        try {
            int n;
            Object object;
            if (this.importTypeSelectPanel.isNewProfile()) {
                int n2;
                CharacterData characterData = this.fileSelectPanel.getCharacterData();
                if (characterData == null || !characterData.isValid() || this.profiles == null) {
                    return;
                }
                object = characterData.getId();
                boolean bl = false;
                for (CharacterData characterData2 : this.profiles) {
                    if (characterData2 == null || !characterData2.isValid() || !characterData2.getId().equals(object)) continue;
                    bl = true;
                    break;
                }
                if (bl && (n2 = JOptionPane.showConfirmDialog(this, properties.getProperty("existsSameProfileId"), properties.getProperty("confirm"), 0, 3)) != 0) {
                    return;
                }
            }
            this.setEnableButtons(false);
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                if (this.importTypeSelectPanel.isNewProfile()) {
                    object = this.createNewProfile();
                    n = 2;
                } else {
                    object = this.updateProfile();
                    n = 1;
                }
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
            }
            this.fileSelectPanel.closeArchive();
            JOptionPane.showMessageDialog(this, properties.getProperty("complete"));
            this.exitCode = n;
            this.importedCharacterData = object;
            this.dispose();
        }
        catch (Exception exception) {
            ErrorMessageHelper.showErrorDialog(this, exception);
            this.updateBtnPanelState();
        }
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public CharacterData getImportedCharacterData() {
        return this.importedCharacterData;
    }

    protected CharacterData createNewProfile() throws IOException {
        Object object;
        CharacterData characterData = this.fileSelectPanel.getCharacterData();
        if (characterData == null || !characterData.isValid()) {
            throw new IllegalStateException("imported caharcer data is invalid." + characterData);
        }
        CharacterDataPersistent characterDataPersistent = CharacterDataPersistent.getInstance();
        CharacterData characterData2 = characterData.duplicateBasicInfo(false);
        characterData2.clearPartsSets(false);
        if (this.importTypeSelectPanel.isImportPreset()) {
            object = this.importPresetSelectPanel.getSelectedPartsSets().iterator();
            while (object.hasNext()) {
                PartsSet partsSet = object.next();
                PartsSet partsSet2 = partsSet.clone();
                partsSet2.setPresetParts(true);
                characterData2.addPartsSet(partsSet2);
            }
            characterData2.setDefaultPartsSetId(this.importPresetSelectPanel.getPrefferedDefaultPartsSetId());
        }
        characterDataPersistent.createProfile(characterData2);
        if (this.importTypeSelectPanel.isImportPartsImages()) {
            object = this.importPartsSelectPanel.getSelectedPartsImageContents();
            this.copyPartsImageContents((Collection<AbstractCharacterDataArchiveFile.PartsImageContent>)object, characterData2);
        }
        if (this.importTypeSelectPanel.isImportSampleImage() && (object = this.fileSelectPanel.getSamplePicture()) != null) {
            characterDataPersistent.saveSamplePicture(characterData2, (BufferedImage)object);
        }
        return characterData2;
    }

    protected CharacterData updateProfile() throws IOException {
        Object object;
        Object object2;
        if (this.current == null || !this.current.isValid()) {
            throw new IllegalStateException("current profile is not valid. :" + this.current);
        }
        CharacterDataPersistent characterDataPersistent = CharacterDataPersistent.getInstance();
        CharacterData characterData = this.current.duplicateBasicInfo(false);
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (this.importTypeSelectPanel.isImportPartsImages()) {
            object2 = this.importPartsSelectPanel.getSelectedPartsImageContents();
            this.copyPartsImageContents((Collection<AbstractCharacterDataArchiveFile.PartsImageContent>)object2, characterData);
            bl = true;
        }
        if (this.importTypeSelectPanel.isImportSampleImage() && (object2 = this.fileSelectPanel.getSamplePicture()) != null) {
            characterDataPersistent.saveSamplePicture(characterData, (BufferedImage)object2);
            bl = true;
        }
        if (this.importTypeSelectPanel.isImportPreset()) {
            for (PartsSet object3 : this.importPresetSelectPanel.getSelectedPartsSets()) {
                object = object3.clone();
                ((PartsSet)object).setPresetParts(false);
                characterData.addPartsSet((PartsSet)object);
            }
            bl = true;
            bl2 = true;
            bl3 = true;
        }
        if (this.importTypeSelectPanel.isAddDescription() && bl) {
            object2 = this.fileSelectPanel.getFile();
            String string = this.importTypeSelectPanel.getAdditionalDescription();
            if (string != null && string.length() > 0) {
                object = characterData.getDescription();
                if (object == null) {
                    object = "";
                }
                String string2 = System.getProperty("line.separator");
                Timestamp timestamp = new Timestamp(System.currentTimeMillis());
                object = (String)object + string2 + "--- import: " + timestamp + " : " + object2 + " ---" + string2;
                object = (String)object + string + string2;
                characterData.setDescription((String)object);
                bl2 = true;
            }
        }
        if (bl2) {
            characterDataPersistent.updateProfile(characterData, false);
        }
        if (bl3) {
            characterDataPersistent.saveFavorites(characterData);
        }
        return characterData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyPartsImageContents(Collection<AbstractCharacterDataArchiveFile.PartsImageContent> collection, CharacterData characterData) throws IOException {
        if (characterData == null || characterData.getDocBase() == null) {
            throw new IllegalArgumentException("invalid character data");
        }
        URL uRL = characterData.getDocBase();
        if (!uRL.getProtocol().equals("file")) {
            throw new IOException("not file protocol: " + uRL);
        }
        File file = new File(uRL.getPath());
        File file2 = file.getParentFile();
        if (file2 == null || !file2.isDirectory()) {
            throw new IOException("not a directory. " + file2);
        }
        AppConfig appConfig = AppConfig.getInstance();
        byte[] byArray = new byte[appConfig.getFileTransferBufferSize()];
        for (AbstractCharacterDataArchiveFile.PartsImageContent partsImageContent : collection) {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(partsImageContent.openStream());
            try {
                File file3 = new File(file2, partsImageContent.getDirName());
                file3.mkdirs();
                File file4 = new File(file3, partsImageContent.getFileName());
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file4));
                try {
                    int n;
                    while ((n = ((InputStream)bufferedInputStream).read(byArray)) >= 0) {
                        ((OutputStream)bufferedOutputStream).write(byArray, 0, n);
                    }
                }
                finally {
                    ((OutputStream)bufferedOutputStream).close();
                }
                file4.setLastModified(partsImageContent.lastModified());
            }
            finally {
                ((InputStream)bufferedInputStream).close();
            }
        }
    }
}

