/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.graphics.filters.ColorConvertParameter;
import charactermanaj.graphics.io.ImageResource;
import charactermanaj.graphics.io.PNGFileImageHeader;
import charactermanaj.model.Layer;
import charactermanaj.model.PartsIdentifier;
import javax.swing.AbstractAction;
import javax.swing.JButton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class InformationModel
implements Comparable<InformationModel> {
    private PartsIdentifier partsIdentifier;
    private Layer layer;
    private ImageResource imageResource;
    private JButton btnOpen;
    private PNGFileImageHeader pngHeader;

    public InformationModel(PartsIdentifier partsIdentifier, Layer layer, ImageResource imageResource, ColorConvertParameter colorConvertParameter, PNGFileImageHeader pNGFileImageHeader, AbstractAction abstractAction) {
        this.partsIdentifier = partsIdentifier;
        this.layer = layer;
        this.imageResource = imageResource;
        this.pngHeader = pNGFileImageHeader;
        this.btnOpen = new JButton(abstractAction){
            private static final long serialVersionUID = 1L;

            public String toString() {
                return "open";
            }
        };
    }

    @Override
    public int compareTo(InformationModel informationModel) {
        int n = this.partsIdentifier.compareTo(informationModel.partsIdentifier);
        if (n == 0) {
            n = this.layer.compareTo(informationModel.layer);
        }
        if (n == 0) {
            n = this.imageResource.compareTo(informationModel.imageResource);
        }
        return n;
    }

    public String getPartsName() {
        return this.partsIdentifier.getLocalizedPartsName();
    }

    public String getCategoryName() {
        return this.partsIdentifier.getPartsCategory().getLocalizedCategoryName();
    }

    public String getLayerName() {
        return this.layer.getLocalizedName();
    }

    public int getLayerOrder() {
        return this.layer.getOrder();
    }

    public String getImageResourceName() {
        return this.imageResource.getFullName();
    }

    public JButton getButton() {
        return this.btnOpen;
    }

    public String getImageSizeStr() {
        if (this.pngHeader == null) {
            return "INVALID";
        }
        return this.pngHeader.getWidth() + "x" + this.pngHeader.getHeight();
    }

    public String getColorTypeStr() {
        if (this.pngHeader == null) {
            return "INVALID";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.pngHeader.getColorType();
        if ((n & 1) != 0) {
            stringBuilder.append("Indexed ");
        }
        if ((n & 2) != 0) {
            stringBuilder.append("Color ");
        } else {
            stringBuilder.append("Greyscale ");
        }
        if ((n & 3) != 0 || this.pngHeader.hasTransparencyInformation()) {
            stringBuilder.append("Alpha ");
        }
        stringBuilder.append(this.pngHeader.getBitDepth() + "bit");
        return stringBuilder.toString().trim();
    }
}

