/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.ui.CategoriesTableRow;
import charactermanaj.ui.ColorGroupsTableRow;
import charactermanaj.ui.LayersTableRow;
import charactermanaj.ui.model.AbstractTableModelWithComboBoxModel;
import charactermanaj.util.ApplicationLogger;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import java.util.Collections;
import java.util.Comparator;
import java.util.Properties;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.table.TableColumnModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LayersTableModel
extends AbstractTableModelWithComboBoxModel<LayersTableRow> {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = ApplicationLogger.getLogger();
    private static final String[] layerColumnNames;
    private static final int[] layersColumnWidths;
    private int serialCounter = 1;

    public void adjustColumnModel(TableColumnModel tableColumnModel) {
        for (int i = 0; i < layersColumnWidths.length; ++i) {
            tableColumnModel.getColumn(i).setPreferredWidth(layersColumnWidths[i]);
        }
    }

    public void addNewLayer() {
        LayersTableRow layersTableRow = new LayersTableRow();
        String string = "lay" + UUID.randomUUID().toString();
        String string2 = "Layer" + this.serialCounter++;
        layersTableRow.setLayerId(string);
        layersTableRow.setLayerName(string2);
        this.addRow(layersTableRow);
    }

    @Override
    public int getColumnCount() {
        return layerColumnNames.length;
    }

    @Override
    public String getColumnName(int n) {
        return layerColumnNames[n];
    }

    @Override
    public Object getValueAt(int n, int n2) {
        LayersTableRow layersTableRow = (LayersTableRow)this.elements.get(n);
        switch (n2) {
            case 0: {
                return layersTableRow.getLayerName();
            }
            case 1: {
                return layersTableRow.getPartsCategory();
            }
            case 2: {
                return layersTableRow.getColorGroup();
            }
            case 3: {
                return layersTableRow.getOrder();
            }
            case 4: {
                return layersTableRow.getDir();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        LayersTableRow layersTableRow = (LayersTableRow)this.elements.get(n);
        try {
            switch (n2) {
                case 0: {
                    layersTableRow.setLayerName((String)object);
                    break;
                }
                case 1: {
                    layersTableRow.setPartsCategory((CategoriesTableRow)object);
                    break;
                }
                case 2: {
                    layersTableRow.setColorGroup((ColorGroupsTableRow)object);
                    break;
                }
                case 3: {
                    layersTableRow.setOrder(((Number)object).intValue());
                    break;
                }
                case 4: {
                    layersTableRow.setDir((String)object);
                    break;
                }
                default: {
                    return;
                }
            }
            this.fireTableCellUpdated(n, n2);
        }
        catch (Exception exception) {
            logger.log(Level.FINE, "value set failed. (" + n + ", " + n2 + "): " + object, exception);
        }
    }

    @Override
    public Class<?> getColumnClass(int n) {
        switch (n) {
            case 0: {
                return String.class;
            }
            case 1: {
                return CategoriesTableRow.class;
            }
            case 2: {
                return ColorGroupsTableRow.class;
            }
            case 3: {
                return Integer.class;
            }
            case 4: {
                return String.class;
            }
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return this.isEditable();
    }

    public void sort() {
        Collections.sort(this.elements, new Comparator<LayersTableRow>(){

            @Override
            public int compare(LayersTableRow layersTableRow, LayersTableRow layersTableRow2) {
                CategoriesTableRow categoriesTableRow;
                CategoriesTableRow categoriesTableRow2 = layersTableRow.getPartsCategory();
                int n = categoriesTableRow2 == (categoriesTableRow = layersTableRow2.getPartsCategory()) ? 0 : (categoriesTableRow2 != null && categoriesTableRow != null ? categoriesTableRow2.compareTo(categoriesTableRow) : (categoriesTableRow2 == null ? -1 : 1));
                if (n == 0) {
                    n = layersTableRow.getOrder() - layersTableRow2.getOrder();
                }
                if (n == 0) {
                    n = layersTableRow.getLayerId().compareTo(layersTableRow2.getLayerId());
                }
                return n;
            }
        });
        this.fireTableDataChanged();
    }

    protected boolean isUsed(ColorGroupsTableRow colorGroupsTableRow) {
        if (colorGroupsTableRow != null) {
            for (LayersTableRow layersTableRow : this.elements) {
                if (!ColorGroupsTableRow.equals(layersTableRow.getColorGroup(), colorGroupsTableRow)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isUsed(CategoriesTableRow categoriesTableRow) {
        if (categoriesTableRow != null) {
            for (LayersTableRow layersTableRow : this.elements) {
                if (!CategoriesTableRow.equals(layersTableRow.getPartsCategory(), categoriesTableRow)) continue;
                return true;
            }
        }
        return false;
    }

    static {
        Properties properties = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties("strings/profileditdialog");
        layerColumnNames = new String[]{properties.getProperty("layers.column.layername"), properties.getProperty("layers.column.category"), properties.getProperty("layers.column.colorgroup"), properties.getProperty("layers.column.order"), properties.getProperty("layers.column.directory")};
        layersColumnWidths = new int[]{Integer.parseInt(properties.getProperty("layers.column.layername.width")), Integer.parseInt(properties.getProperty("layers.column.category.width")), Integer.parseInt(properties.getProperty("layers.column.colorgroup.width")), Integer.parseInt(properties.getProperty("layers.column.order.width")), Integer.parseInt(properties.getProperty("layers.column.directory.width"))};
    }
}

