/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.model.PartsCategory;
import charactermanaj.model.PartsIdentifier;
import charactermanaj.ui.PartsSelectRow;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PartsSelectListModel
extends AbstractTableModel {
    private static final long serialVersionUID = 7604828023134579608L;
    private PartsCategory partsCategory;
    private ArrayList<PartsSelectRow> partsSelectRowList;

    public PartsSelectListModel(PartsCategory partsCategory) {
        if (partsCategory == null) {
            throw new IllegalArgumentException();
        }
        this.partsSelectRowList = new ArrayList();
        this.partsCategory = partsCategory;
    }

    public void load(Collection<PartsIdentifier> collection) {
        if (collection == null) {
            throw new IllegalArgumentException();
        }
        HashMap<PartsIdentifier, Integer> hashMap = new HashMap<PartsIdentifier, Integer>();
        for (PartsIdentifier object2 : this.getSelectedPartsIdentifiers()) {
            hashMap.put(object2, hashMap.size());
        }
        ArrayList arrayList = new ArrayList();
        Iterator<PartsIdentifier> iterator = collection.iterator();
        while (iterator.hasNext()) {
            PartsIdentifier partsIdentifier;
            Integer n = (Integer)hashMap.get(partsIdentifier = iterator.next());
            PartsSelectRow partsSelectRow = new PartsSelectRow(partsIdentifier, n != null);
            int n2 = n != null ? n : 0;
            partsSelectRow.setDisplayOrder(n2);
            arrayList.add(partsSelectRow);
        }
        if (this.partsCategory.isMultipleSelectable()) {
            Collections.sort(arrayList);
        } else {
            Collections.sort(arrayList, new Comparator<PartsSelectRow>(){

                @Override
                public int compare(PartsSelectRow partsSelectRow, PartsSelectRow partsSelectRow2) {
                    return partsSelectRow.getPartsIdentifier().compareTo(partsSelectRow2.getPartsIdentifier());
                }
            });
        }
        this.partsSelectRowList = arrayList;
        this.fireTableDataChanged();
    }

    public PartsSelectRow getRow(int n) {
        return this.partsSelectRowList.get(n);
    }

    public ArrayList<PartsSelectRow> getRowModelList() {
        return this.partsSelectRowList;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return this.partsSelectRowList.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        PartsSelectRow partsSelectRow = this.partsSelectRowList.get(n);
        switch (n2) {
            case 0: {
                return partsSelectRow.isChecked();
            }
            case 1: {
                return partsSelectRow.getPartsName();
            }
        }
        return "";
    }

    @Override
    public Class<?> getColumnClass(int n) {
        switch (n) {
            case 0: {
                return Boolean.class;
            }
            case 1: {
                return String.class;
            }
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 == 0;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (n2 != 0) {
            return;
        }
        PartsSelectRow partsSelectRow = this.partsSelectRowList.get(n);
        boolean bl = (Boolean)object;
        if (!bl && partsSelectRow.isChecked() && !this.partsCategory.isMultipleSelectable()) {
            return;
        }
        partsSelectRow.setChecked(bl);
        boolean bl2 = false;
        if (bl && !this.partsCategory.isMultipleSelectable()) {
            int n3 = this.partsSelectRowList.size();
            for (int i = 0; i < n3; ++i) {
                PartsSelectRow partsSelectRow2;
                if (i == n || !(partsSelectRow2 = this.partsSelectRowList.get(i)).isChecked()) continue;
                partsSelectRow2.setChecked(false);
                bl2 = true;
            }
        }
        if (!bl2) {
            this.fireTableCellUpdated(n, n2);
        } else {
            this.fireTableDataChanged();
        }
    }

    public void sort() {
        int n = this.partsSelectRowList.size();
        for (int i = 0; i < n; ++i) {
            this.partsSelectRowList.get(i).setDisplayOrder(i);
        }
        Collections.sort(this.partsSelectRowList);
        this.fireTableDataChanged();
    }

    public List<PartsIdentifier> getSelectedPartsIdentifiers() {
        ArrayList<PartsIdentifier> arrayList = new ArrayList<PartsIdentifier>();
        for (PartsSelectRow partsSelectRow : this.partsSelectRowList) {
            if (!partsSelectRow.isChecked()) continue;
            arrayList.add(partsSelectRow.getPartsIdentifier());
        }
        return arrayList;
    }

    public boolean[] getChecks(int[] nArray) {
        if (nArray == null) {
            nArray = new int[]{};
        }
        int n = nArray.length;
        boolean[] blArray = new boolean[n];
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            PartsSelectRow partsSelectRow = this.partsSelectRowList.get(n2);
            blArray[i] = partsSelectRow.isChecked();
        }
        return blArray;
    }

    public void setChecks(boolean bl, int[] nArray) {
        PartsSelectRow partsSelectRow;
        int n2;
        if (nArray == null || nArray.length == 0) {
            return;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (!bl) {
            if (!this.partsCategory.isMultipleSelectable()) {
                return;
            }
            for (int n2 : nArray) {
                partsSelectRow = this.partsSelectRowList.get(n2);
                if (!partsSelectRow.isChecked()) continue;
                partsSelectRow.setChecked(false);
                arrayList.add(n2);
            }
        } else if (this.partsCategory.isMultipleSelectable()) {
            for (int n2 : nArray) {
                partsSelectRow = this.partsSelectRowList.get(n2);
                if (partsSelectRow.isChecked()) continue;
                partsSelectRow.setChecked(true);
                arrayList.add(n2);
            }
        } else {
            int n3 = nArray[0];
            PartsSelectRow partsSelectRow2 = this.partsSelectRowList.get(n3);
            if (!partsSelectRow2.isChecked()) {
                partsSelectRow2.setChecked(true);
                arrayList.add(n3);
                int n4 = this.partsSelectRowList.size();
                for (n2 = 0; n2 < n4; ++n2) {
                    partsSelectRow = this.partsSelectRowList.get(n2);
                    if (n2 == n3 || !partsSelectRow.isChecked()) continue;
                    partsSelectRow.setChecked(false);
                    arrayList.add(n2);
                }
            }
        }
        if (arrayList.isEmpty()) {
            return;
        }
        int n5 = 0;
        int n6 = 0;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            n2 = (Integer)iterator.next();
            n5 = Math.min(n5, n2);
            n6 = Math.max(n6, n2);
        }
        this.fireTableRowsUpdated(n5, n6);
    }
}

