/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui.model;

import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.swing.ComboBoxModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTableModelWithComboBoxModel<T>
extends AbstractTableModel
implements ComboBoxModel {
    private static final long serialVersionUID = -6775939667002896930L;
    protected ArrayList<T> elements = new ArrayList();
    private boolean editable = true;
    private Object selectedObject;
    private LinkedList<ListDataListener> listDataListeners = new LinkedList();

    public boolean removeRow(int n) {
        if (n < 0 || n >= this.elements.size()) {
            return false;
        }
        this.elements.remove(n);
        this.fireTableRowsDeleted(n, n);
        return true;
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void clear() {
        this.elements.clear();
        this.fireTableDataChanged();
    }

    public T getRow(int n) {
        return this.elements.get(n);
    }

    @Override
    public Object getElementAt(int n) {
        return this.getRow(n);
    }

    public boolean addRow(T t) {
        if (t == null) {
            throw new IllegalArgumentException();
        }
        boolean bl = this.elements.add(t);
        int n = this.elements.size() - 1;
        this.fireTableRowsInserted(n, n);
        return bl;
    }

    public int moveUp(int n) {
        if (n < 1 || n >= this.elements.size()) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            toolkit.beep();
            return n;
        }
        T t = this.elements.get(n);
        this.elements.remove(n);
        this.elements.add(n - 1, t);
        this.fireTableRowsUpdated(n - 1, n);
        return n - 1;
    }

    public int moveDown(int n) {
        if (n < 0 || n >= this.elements.size() - 1) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            toolkit.beep();
            return n;
        }
        T t = this.elements.get(n);
        this.elements.remove(n);
        this.elements.add(n + 1, t);
        this.fireTableRowsUpdated(n, n + 1);
        return n + 1;
    }

    @Override
    public void fireTableCellUpdated(int n, int n2) {
        super.fireTableCellUpdated(n, n2);
        this.fireListUpdated(n, n);
    }

    @Override
    public void fireTableRowsDeleted(int n, int n2) {
        super.fireTableRowsDeleted(n, n2);
        this.fireListRemoved(n, n2);
    }

    @Override
    public void fireTableRowsInserted(int n, int n2) {
        super.fireTableRowsInserted(n, n2);
        this.fireListAdded(n, n2);
    }

    @Override
    public void fireTableRowsUpdated(int n, int n2) {
        super.fireTableRowsUpdated(n, n2);
        this.fireListUpdated(n, n2);
    }

    @Override
    public void fireTableDataChanged() {
        super.fireTableDataChanged();
        int n = this.getRowCount();
        if (n > 0) {
            this.fireListUpdated(0, n - 1);
        }
    }

    @Override
    public int getRowCount() {
        return this.elements.size();
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedObject;
    }

    @Override
    public void setSelectedItem(Object object) {
        this.selectedObject = object;
    }

    @Override
    public void removeListDataListener(ListDataListener listDataListener) {
        if (listDataListener != null) {
            this.listDataListeners.remove(listDataListener);
        }
    }

    @Override
    public void addListDataListener(ListDataListener listDataListener) {
        if (listDataListener != null) {
            this.listDataListeners.add(listDataListener);
        }
    }

    public void fireListUpdated(int n, int n2) {
        ListDataEvent listDataEvent = new ListDataEvent(this, 0, n, n2);
        for (ListDataListener listDataListener : this.listDataListeners) {
            listDataListener.contentsChanged(listDataEvent);
        }
    }

    public void fireListAdded(int n, int n2) {
        ListDataEvent listDataEvent = new ListDataEvent(this, 1, n, n2);
        for (ListDataListener listDataListener : this.listDataListeners) {
            listDataListener.intervalAdded(listDataEvent);
        }
    }

    public void fireListRemoved(int n, int n2) {
        ListDataEvent listDataEvent = new ListDataEvent(this, 2, n, n2);
        for (ListDataListener listDataListener : this.listDataListeners) {
            listDataListener.intervalRemoved(listDataEvent);
        }
    }

    @Override
    public int getSize() {
        return this.getRowCount();
    }
}

