/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui.model;

import charactermanaj.graphics.filters.ColorConvertParameter;
import charactermanaj.model.ColorGroup;
import charactermanaj.model.ColorInfo;
import charactermanaj.model.Layer;
import charactermanaj.model.PartsCategory;
import charactermanaj.model.PartsColorInfo;
import charactermanaj.model.PartsColorManager;
import charactermanaj.model.PartsIdentifier;
import charactermanaj.ui.ColorDialog;
import charactermanaj.ui.model.ColorChangeEvent;
import charactermanaj.ui.model.ColorChangeListener;
import charactermanaj.ui.model.PartsSelectionManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ColorGroupCoordinator {
    private PartsSelectionManager partsSelectionMrg;
    private LinkedList<ColorDialog> colorDialogs = new LinkedList();
    private LinkedList<ColorChangeListener> listeners = new LinkedList();
    private PartsColorManager partsColorMrg;
    protected ColorChangeListener listener;

    public ColorGroupCoordinator(PartsSelectionManager partsSelectionManager, PartsColorManager partsColorManager) {
        if (partsSelectionManager == null || partsColorManager == null) {
            throw new IllegalArgumentException();
        }
        this.partsSelectionMrg = partsSelectionManager;
        this.partsColorMrg = partsColorManager;
        this.listener = new ColorChangeListener(){

            public void onColorChange(ColorChangeEvent colorChangeEvent) {
                Layer layer = colorChangeEvent.getLayer();
                ColorDialog colorDialog = (ColorDialog)colorChangeEvent.getSource();
                PartsCategory partsCategory = colorDialog.getPartsCategory();
                ColorGroupCoordinator.this.syncColorGroup(partsCategory, layer, colorDialog);
                ColorGroupCoordinator.this.fireColorChangeEvent(colorChangeEvent);
            }

            public void onColorGroupChange(ColorChangeEvent colorChangeEvent) {
                Layer layer = colorChangeEvent.getLayer();
                ColorDialog colorDialog = (ColorDialog)colorChangeEvent.getSource();
                ColorGroup colorGroup = colorDialog.getColorGroup(layer);
                ColorGroupCoordinator.this.onChangeColorGroup(colorDialog, layer, colorGroup);
                ColorGroupCoordinator.this.fireColorGroupChangeEvent(colorChangeEvent);
            }
        };
    }

    public void registerColorDialog(ColorDialog colorDialog) {
        if (colorDialog == null) {
            throw new IllegalArgumentException();
        }
        this.colorDialogs.add(colorDialog);
        colorDialog.addColorChangeListener(this.listener);
    }

    public void unregisterColorDialog(ColorDialog colorDialog) {
        Iterator iterator = this.colorDialogs.iterator();
        while (iterator.hasNext()) {
            ColorDialog colorDialog2 = (ColorDialog)iterator.next();
            if (colorDialog2 != colorDialog) continue;
            colorDialog2.removeColorChangeListener(this.listener);
            iterator.remove();
        }
    }

    public void addColorChangeListener(ColorChangeListener colorChangeListener) {
        if (colorChangeListener == null) {
            throw new IllegalArgumentException();
        }
        this.listeners.add(colorChangeListener);
    }

    public void removeColorChangeListener(ColorChangeListener colorChangeListener) {
        this.listeners.remove(colorChangeListener);
    }

    protected void fireColorChangeEvent(ColorChangeEvent colorChangeEvent) {
        if (colorChangeEvent == null) {
            throw new IllegalArgumentException();
        }
        for (ColorChangeListener colorChangeListener : this.listeners) {
            colorChangeListener.onColorChange(colorChangeEvent);
        }
    }

    protected void fireColorGroupChangeEvent(ColorChangeEvent colorChangeEvent) {
        if (colorChangeEvent == null) {
            throw new IllegalArgumentException();
        }
        for (ColorChangeListener colorChangeListener : this.listeners) {
            colorChangeListener.onColorGroupChange(colorChangeEvent);
        }
    }

    protected void onChangeColorGroup(ColorDialog colorDialog, Layer layer, ColorGroup colorGroup) {
        if (colorDialog == null || layer == null || colorGroup == null) {
            throw new IllegalArgumentException();
        }
        block0: for (ColorDialog colorDialog2 : this.colorDialogs) {
            for (Layer layer2 : colorDialog2.getPartsCategory().getLayers()) {
                if (layer2.equals(layer) || !ColorGroup.equals(colorGroup, colorDialog2.getColorGroup(layer2)) || !colorDialog2.isSyncColorGroup(layer2)) continue;
                ColorConvertParameter colorConvertParameter = colorDialog2.getColorConvertParameter(layer2);
                colorDialog.setColorConvertParameter(layer, colorConvertParameter);
                continue block0;
            }
        }
    }

    public void syncColorGroup(PartsCategory partsCategory, Layer layer, ColorDialog colorDialog) {
        if (partsCategory == null || layer == null || colorDialog == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<Layer> arrayList = new ArrayList<Layer>();
        if (layer != null) {
            if (colorDialog.isSyncColorGroup(layer)) {
                arrayList.add(layer);
            }
        } else {
            for (Layer layer2 : partsCategory.getLayers()) {
                if (!colorDialog.isSyncColorGroup(layer2)) continue;
                arrayList.add(layer2);
            }
        }
        for (Layer layer2 : arrayList) {
            ColorGroup colorGroup = colorDialog.getColorGroup(layer2);
            if (colorGroup == null || !colorGroup.isEnabled()) continue;
            ColorConvertParameter colorConvertParameter = colorDialog.getColorConvertParameter(layer2);
            for (ColorDialog colorDialog2 : this.colorDialogs) {
                for (Layer layer3 : colorDialog2.getPartsCategory().getLayers()) {
                    if (layer3.equals(layer2) || !ColorGroup.equals(colorDialog2.getColorGroup(layer3), colorGroup) || !colorDialog2.isSyncColorGroup(layer3)) continue;
                    colorDialog2.setColorConvertParameter(layer3, colorConvertParameter);
                }
            }
            for (PartsCategory partsCategory2 : this.partsSelectionMrg.getAllCategories()) {
                List<PartsIdentifier> list = this.partsSelectionMrg.getSelectedPartsIdentifiers(partsCategory2);
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    PartsIdentifier partsIdentifier = (PartsIdentifier)iterator.next();
                    PartsColorInfo partsColorInfo = this.partsColorMrg.getPartsColorInfo(partsIdentifier, true);
                    for (Map.Entry<Layer, ColorInfo> entry : partsColorInfo.entrySet()) {
                        ColorInfo colorInfo = entry.getValue();
                        if (!ColorGroup.equals(colorGroup, colorInfo.getColorGroup()) || !colorInfo.isSyncColorGroup()) continue;
                        colorInfo.setColorParameter(colorConvertParameter);
                    }
                }
            }
        }
    }
}

