/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui.model;

import charactermanaj.model.PartsCategory;
import charactermanaj.model.PartsColorInfo;
import charactermanaj.model.PartsColorManager;
import charactermanaj.model.PartsIdentifier;
import charactermanaj.model.PartsSet;
import charactermanaj.ui.ImageSelectPanel;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartsSelectionManager {
    private HashMap<PartsCategory, ImageSelectPanel> imageSelectPanels = new HashMap();
    private PartsColorManager partsColorMrg;
    private Color imageBgColor = Color.white;
    private double[] affineTransformParameter;

    public void loadParts() {
        for (ImageSelectPanel imageSelectPanel : this.imageSelectPanels.values()) {
            imageSelectPanel.loadParts();
        }
    }

    public PartsSelectionManager(PartsColorManager partsColorManager) {
        if (partsColorManager == null) {
            throw new IllegalArgumentException();
        }
        this.partsColorMrg = partsColorManager;
    }

    public void register(ImageSelectPanel imageSelectPanel) {
        if (imageSelectPanel == null) {
            throw new IllegalArgumentException();
        }
        this.imageSelectPanels.put(imageSelectPanel.getPartsCategory(), imageSelectPanel);
    }

    public List<PartsIdentifier> getSelectedPartsIdentifiers(PartsCategory partsCategory) {
        if (partsCategory == null) {
            throw new IllegalArgumentException();
        }
        ImageSelectPanel imageSelectPanel = this.imageSelectPanels.get(partsCategory);
        if (imageSelectPanel != null) {
            return Collections.unmodifiableList(imageSelectPanel.getSelectedPartsIdentifiers());
        }
        return Collections.emptyList();
    }

    public PartsIdentifier getSelectedPartsIdentifier(PartsCategory partsCategory) {
        if (partsCategory == null) {
            throw new IllegalArgumentException();
        }
        ImageSelectPanel imageSelectPanel = this.imageSelectPanels.get(partsCategory);
        if (imageSelectPanel != null) {
            return imageSelectPanel.getSelectedPartsIdentifier();
        }
        return null;
    }

    public Collection<PartsCategory> getAllCategories() {
        ArrayList<PartsCategory> arrayList = new ArrayList<PartsCategory>();
        arrayList.addAll(this.imageSelectPanels.keySet());
        return arrayList;
    }

    public void selectPartsSet(PartsSet partsSet) {
        if (partsSet == null) {
            throw new IllegalArgumentException();
        }
        for (ImageSelectPanel imageSelectPanel : this.imageSelectPanels.values()) {
            PartsCategory partsCategory = imageSelectPanel.getPartsCategory();
            List list = (List)partsSet.get(partsCategory);
            imageSelectPanel.selectParts(list);
            if (list == null) continue;
            for (PartsIdentifier partsIdentifier : list) {
                PartsColorInfo partsColorInfo = partsSet.getColorInfo(partsIdentifier);
                if (partsColorInfo == null) continue;
                this.partsColorMrg.setPartsColorInfo(partsIdentifier, partsColorInfo, false);
            }
        }
        Color color = partsSet.getBgColor();
        if (color != null) {
            this.imageBgColor = color;
        }
        this.affineTransformParameter = partsSet.getAffineTransformParameter();
    }

    public PartsSet createPartsSet() {
        PartsSet partsSet = new PartsSet();
        for (ImageSelectPanel imageSelectPanel : this.imageSelectPanels.values()) {
            PartsCategory partsCategory = imageSelectPanel.getPartsCategory();
            for (PartsIdentifier partsIdentifier : imageSelectPanel.getSelectedPartsIdentifiers()) {
                PartsColorInfo partsColorInfo = this.partsColorMrg.getPartsColorInfo(partsIdentifier, false);
                partsSet.appendParts(partsCategory, partsIdentifier, partsColorInfo);
            }
        }
        partsSet.setBgColor(this.imageBgColor);
        partsSet.setAffineTransformParameter(this.affineTransformParameter);
        return partsSet;
    }

    public void scrollToSelectedParts() {
        for (ImageSelectPanel imageSelectPanel : this.imageSelectPanels.values()) {
            imageSelectPanel.scrollToSelectedRow();
        }
    }

    public Color getImageBgColor() {
        return this.imageBgColor;
    }

    public void setImageBgColor(Color color) {
        if (color == null) {
            color = Color.white;
        }
        this.imageBgColor = color;
    }

    public double[] getAffineTransformParameter() {
        return this.affineTransformParameter == null ? null : (double[])this.affineTransformParameter.clone();
    }

    public void setAffineTransformParameter(double[] dArray) {
        if (dArray != null && dArray.length != 4 && dArray.length != 6) {
            throw new IllegalArgumentException("affineTransformParameter invalid length.");
        }
        this.affineTransformParameter = dArray == null ? null : (double[])dArray.clone();
    }
}

