/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.util;

import charactermanaj.model.AppConfig;
import charactermanaj.util.ConfigurationDirUtilities;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class ApplicationLogHandler
extends Handler {
    private static final String LOGS_DIR = "logs";
    private final Object lock = new Object();
    private final File logFile;
    private PrintWriter pw;
    private boolean notRemove;

    public ApplicationLogHandler() {
        PrintWriter printWriter;
        File file = ConfigurationDirUtilities.getUserDataDir();
        File file2 = new File(file, LOGS_DIR);
        file2.mkdirs();
        String string = this.getCurrentTime() + ".log";
        this.logFile = new File(file2, string);
        try {
            printWriter = new PrintWriter(new OutputStreamWriter(new FileOutputStream(this.logFile)));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            printWriter = null;
        }
        this.pw = printWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SecurityException {
        Object object = this.lock;
        synchronized (object) {
            try {
                AppConfig appConfig = AppConfig.getInstance();
                if (appConfig.isNoRemoveLog()) {
                    this.notRemove = true;
                }
            }
            catch (Exception exception) {
                this.notRemove = true;
                try {
                    if (this.pw != null) {
                        exception.printStackTrace(this.pw);
                    }
                }
                catch (Exception exception2) {
                    exception2.printStackTrace();
                }
            }
            if (this.pw != null) {
                this.pw.close();
                this.pw = null;
            }
            if (this.logFile != null && !this.notRemove) {
                this.logFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        Object object = this.lock;
        synchronized (object) {
            if (this.pw != null) {
                this.pw.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(LogRecord logRecord) {
        if (logRecord == null) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.pw == null) {
                return;
            }
            Level level = logRecord.getLevel();
            this.pw.println("### " + this.getCurrentTime() + ", " + level.getLocalizedName() + ", " + logRecord.getMessage());
            Throwable throwable = logRecord.getThrown();
            if (throwable != null) {
                throwable.printStackTrace(this.pw);
            }
            this.pw.flush();
            if (level.intValue() >= Level.WARNING.intValue()) {
                this.notRemove = true;
            }
        }
    }

    public String getCurrentTime() {
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd_HHmmssSSS");
        return simpleDateFormat.format(timestamp);
    }
}

