/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.util;

import charactermanaj.util.ApplicationLogger;
import java.awt.Color;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BeanPropertiesUtilities {
    private static final Logger logger = ApplicationLogger.getLogger();

    private BeanPropertiesUtilities() {
        throw new RuntimeException("utilities class.");
    }

    public static Set<String> loadFromProperties(Object object, Properties properties) {
        if (object == null || properties == null) {
            throw new IllegalArgumentException();
        }
        HashSet<String> hashSet = new HashSet<String>();
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(object.getClass());
            for (PropertyDescriptor propertyDescriptor : beanInfo.getPropertyDescriptors()) {
                String string;
                String string2;
                Class<?> clazz = propertyDescriptor.getPropertyType();
                Method method = propertyDescriptor.getReadMethod();
                Method method2 = propertyDescriptor.getWriteMethod();
                if (method == null || method2 == null || (string2 = properties.getProperty(string = propertyDescriptor.getName())) == null) continue;
                try {
                    Object object2;
                    if (String.class.equals(clazz)) {
                        object2 = string2;
                    } else if (string2.length() == 0) {
                        object2 = null;
                    } else if (Boolean.class.equals(clazz) || Boolean.TYPE.equals(clazz)) {
                        object2 = Boolean.valueOf(string2);
                    } else if (Integer.class.equals(clazz) || Integer.TYPE.equals(clazz)) {
                        object2 = Integer.valueOf(string2);
                    } else if (Long.class.equals(clazz) || Long.TYPE.equals(clazz)) {
                        object2 = Long.valueOf(string2);
                    } else if (Float.class.equals(clazz) || Float.TYPE.equals(clazz)) {
                        object2 = Float.valueOf(string2);
                    } else if (Double.class.equals(clazz) || Double.TYPE.equals(clazz)) {
                        object2 = Double.valueOf(string2);
                    } else if (BigInteger.class.equals(clazz)) {
                        object2 = new BigInteger(string2);
                    } else if (BigDecimal.class.equals(clazz)) {
                        object2 = new BigDecimal(string2);
                    } else if (Color.class.equals(clazz)) {
                        object2 = Color.decode(string2);
                    } else {
                        hashSet.add(string);
                        logger.log(Level.WARNING, "unsupported propery type: " + clazz + "/beanClass=" + object.getClass() + " #" + string);
                        continue;
                    }
                    method2.invoke(object, object2);
                }
                catch (Exception exception) {
                    hashSet.add(string);
                    logger.log(Level.WARNING, "invalid propery: " + clazz + "/beanClass=" + object.getClass() + " #" + string + " /val=" + string2);
                }
            }
        }
        catch (IntrospectionException introspectionException) {
            throw new RuntimeException("bean intorospector failed. :" + object.getClass(), introspectionException);
        }
        return hashSet;
    }

    public static void saveToProperties(Object object, Properties properties) {
        if (object == null || properties == null) {
            throw new IllegalArgumentException();
        }
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(object.getClass());
            for (PropertyDescriptor propertyDescriptor : beanInfo.getPropertyDescriptors()) {
                String string;
                Method method = propertyDescriptor.getReadMethod();
                Method method2 = propertyDescriptor.getWriteMethod();
                if (method == null || method2 == null) continue;
                String string2 = propertyDescriptor.getName();
                Object object2 = method.invoke(object, new Object[0]);
                if (object2 == null) {
                    string = "";
                } else if (object2 instanceof String) {
                    string = (String)object2;
                } else if (object2 instanceof Number) {
                    string = ((Number)object2).toString();
                } else if (object2 instanceof Boolean) {
                    string = (Boolean)object2 != false ? "true" : "false";
                } else if (object2 instanceof Color) {
                    string = "#" + Integer.toHexString(((Color)object2).getRGB() & 0xFFFFFF);
                } else {
                    logger.log(Level.WARNING, "unsupported propery type: " + object2.getClass() + "/beanClass=" + object.getClass() + " #" + string2);
                    continue;
                }
                properties.setProperty(string2, string);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("bean property read failed. :" + object.getClass(), illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException("bean property read failed. :" + object.getClass(), invocationTargetException);
        }
        catch (IntrospectionException introspectionException) {
            throw new RuntimeException("bean intorospector failed. :" + object.getClass(), introspectionException);
        }
    }
}

