/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.util;

import java.io.File;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;

public final class ConfigurationDirUtilities {
    public static final String CONFIGURATION_DIR_NAME = ".charactermanaj";
    private static File userDataDir;
    private static File applicationBaseDir;

    private ConfigurationDirUtilities() {
        throw new RuntimeException("utilities class.");
    }

    public static File getUserDataDir() {
        if (userDataDir == null) {
            String string = null;
            try {
                string = System.getProperty("APPDATA");
                if (string == null) {
                    // empty if block
                }
                string = System.getenv("APPDATA");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            if (string == null) {
                string = System.getProperty("user.home");
            }
            userDataDir = new File(string, CONFIGURATION_DIR_NAME).getAbsoluteFile();
            userDataDir.mkdirs();
        }
        return userDataDir;
    }

    public static File getApplicationBaseDir() {
        if (applicationBaseDir == null) {
            ProtectionDomain protectionDomain = ConfigurationDirUtilities.class.getProtectionDomain();
            CodeSource codeSource = protectionDomain.getCodeSource();
            if (codeSource == null) {
                throw new RuntimeException("codeSource is null: domain=" + protectionDomain);
            }
            URL uRL = codeSource.getLocation();
            if (!uRL.getProtocol().equals("file")) {
                throw new RuntimeException("codeLocation is not file protocol.: " + uRL);
            }
            applicationBaseDir = new File(uRL.getPath()).getParentFile();
        }
        return applicationBaseDir;
    }
}

