/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.util;

import charactermanaj.util.ApplicationLogger;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DesktopUtilities {
    private static final Logger logger = ApplicationLogger.getLogger();
    private static Object desktopObj;
    private static Method methodBrowse;
    private static Method methodEdit;
    private static Method methodOpen;

    private DesktopUtilities() {
        throw new RuntimeException("utilities class.");
    }

    public static boolean isSupported() {
        return desktopObj != null;
    }

    protected static boolean callMethod(Method method, Object object) throws IOException {
        if (desktopObj == null) {
            return false;
        }
        try {
            method.invoke(desktopObj, object);
            return true;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable != null && throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            throw new RuntimeException(invocationTargetException.getMessage(), invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException.getMessage(), illegalAccessException);
        }
    }

    public static boolean browse(URI uRI) throws IOException {
        return DesktopUtilities.callMethod(methodBrowse, uRI);
    }

    public static boolean browseBaseDir(URL uRL) throws IOException {
        Object object;
        URI uRI = null;
        try {
            if (uRL != null) {
                object = new File(uRL.getPath()).getParentFile();
                uRI = ((File)object).toURI();
            }
        }
        catch (Exception exception) {
            uRI = null;
        }
        if (uRI == null) {
            object = Toolkit.getDefaultToolkit();
            ((Toolkit)object).beep();
            return false;
        }
        return DesktopUtilities.browse(uRI);
    }

    public static boolean edit(File file) throws IOException {
        return DesktopUtilities.callMethod(methodEdit, file);
    }

    public static boolean open(File file) throws IOException {
        return DesktopUtilities.callMethod(methodOpen, file);
    }

    static {
        try {
            Class<?> clazz = Class.forName("java.awt.Desktop");
            Method method = clazz.getMethod("getDesktop", new Class[0]);
            methodBrowse = clazz.getMethod("browse", URI.class);
            methodEdit = clazz.getMethod("edit", File.class);
            methodOpen = clazz.getMethod("open", File.class);
            desktopObj = method.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.log(Level.INFO, "AWT Desktop is not suuported.");
            desktopObj = null;
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, "AWT Desktop failed.", exception);
            desktopObj = null;
        }
    }
}

