/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.util;

import charactermanaj.util.ApplicationLogger;
import charactermanaj.util.UserData;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

class FileUserData
implements UserData {
    private static final Logger logger = ApplicationLogger.getLogger();
    private File file;

    public FileUserData(File file) {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        this.file = file;
    }

    public boolean exists() {
        return this.file.exists() && this.file.isFile();
    }

    public long lastModified() {
        return this.file.lastModified();
    }

    public InputStream openStream() throws IOException {
        return new BufferedInputStream(new FileInputStream(this.file));
    }

    public OutputStream getOutputStream() throws IOException {
        return new BufferedOutputStream(new FileOutputStream(this.file));
    }

    public boolean delete() {
        try {
            return this.file.delete();
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "file removing failed." + this.file, exception);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(Object object) throws IOException {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(this.getOutputStream());
        try {
            objectOutputStream.writeObject(object);
            objectOutputStream.close();
        }
        finally {
            objectOutputStream.close();
        }
    }

    public Object load() throws IOException {
        ObjectInputStream objectInputStream = new ObjectInputStream(this.openStream());
        try {
            Object object = objectInputStream.readObject();
            return object;
        }
        catch (ClassNotFoundException classNotFoundException) {
            IOException iOException = new IOException("invalid format.");
            iOException.initCause(iOException);
            throw iOException;
        }
        finally {
            objectInputStream.close();
        }
    }

    public String toString() {
        return "FileUserData{file:" + this.file + "}";
    }
}

