/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.util;

import charactermanaj.util.ResourceLoader;
import java.awt.Component;
import java.awt.Container;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenu;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UIHelper
extends ResourceLoader {
    private static final UIHelper singleton = new UIHelper();

    private UIHelper() {
    }

    public static final UIHelper getInstance() {
        return singleton;
    }

    public <T> Collection<T> getDescendantOfClass(Class<T> clazz, Container container) {
        if (container == null || clazz == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<Component> arrayList = new ArrayList<Component>();
        this.getDescendantOfClass(clazz, container, arrayList);
        return arrayList;
    }

    private void getDescendantOfClass(Class<?> clazz, Container container, Collection<Component> collection) {
        if (container == null) {
            return;
        }
        for (Component component : container instanceof JMenu ? ((JMenu)container).getMenuComponents() : container.getComponents()) {
            if (clazz.isInstance(component)) {
                collection.add(component);
                continue;
            }
            if (!(component instanceof Container)) continue;
            this.getDescendantOfClass(clazz, (Container)component, collection);
        }
    }

    public JButton createIconButton(String string) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException();
        }
        JButton jButton = new JButton();
        jButton.setIcon(new ImageIcon(this.getImage(string)));
        return jButton;
    }

    public JButton createTransparentButton(String string) {
        return this.createTransparentButton(string, null);
    }

    public JButton createTransparentButton(String string, String string2) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException();
        }
        ImageIcon imageIcon = new ImageIcon(this.getImage(string));
        JButton jButton = new JButton(imageIcon);
        if (string2 != null && string2.length() != 0) {
            ImageIcon imageIcon2 = new ImageIcon(this.getImage(string2));
            jButton.setRolloverEnabled(true);
            jButton.setRolloverIcon(imageIcon2);
            jButton.setPressedIcon(imageIcon2);
        }
        jButton.setOpaque(false);
        jButton.setBorderPainted(false);
        jButton.setContentAreaFilled(false);
        return jButton;
    }

    public BufferedImage getImage(String string) {
        URL uRL = this.getResource(string);
        if (uRL == null) {
            throw new RuntimeException("resource not found. " + string);
        }
        try {
            return ImageIO.read(uRL);
        }
        catch (IOException iOException) {
            throw new RuntimeException("image load error." + iOException.getMessage(), iOException);
        }
    }
}

