/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.zip;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipException;
import org.apache.tools.zip.AsiExtraField;
import org.apache.tools.zip.CentralDirectoryParsingZipExtraField;
import org.apache.tools.zip.JarMarker;
import org.apache.tools.zip.UnicodeCommentExtraField;
import org.apache.tools.zip.UnicodePathExtraField;
import org.apache.tools.zip.UnparseableExtraFieldData;
import org.apache.tools.zip.UnrecognizedExtraField;
import org.apache.tools.zip.ZipExtraField;
import org.apache.tools.zip.ZipShort;

public class ExtraFieldUtils {
    private static final int WORD = 4;
    private static final Map implementations = new HashMap();

    public static void register(Class clazz) {
        try {
            ZipExtraField zipExtraField = (ZipExtraField)clazz.newInstance();
            implementations.put(zipExtraField.getHeaderId(), clazz);
        }
        catch (ClassCastException classCastException) {
            throw new RuntimeException(clazz + " doesn't implement ZipExtraField");
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException(clazz + " is not a concrete class");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(clazz + "'s no-arg constructor is not public");
        }
    }

    public static ZipExtraField createExtraField(ZipShort zipShort) throws InstantiationException, IllegalAccessException {
        Class clazz = (Class)implementations.get(zipShort);
        if (clazz != null) {
            return (ZipExtraField)clazz.newInstance();
        }
        UnrecognizedExtraField unrecognizedExtraField = new UnrecognizedExtraField();
        unrecognizedExtraField.setHeaderId(zipShort);
        return unrecognizedExtraField;
    }

    public static ZipExtraField[] parse(byte[] byArray) throws ZipException {
        return ExtraFieldUtils.parse(byArray, true, UnparseableExtraField.THROW);
    }

    public static ZipExtraField[] parse(byte[] byArray, boolean bl) throws ZipException {
        return ExtraFieldUtils.parse(byArray, bl, UnparseableExtraField.THROW);
    }

    public static ZipExtraField[] parse(byte[] byArray, boolean bl, UnparseableExtraField unparseableExtraField) throws ZipException {
        Object object;
        int n;
        ArrayList<ZipExtraField> arrayList = new ArrayList<ZipExtraField>();
        block8: for (int i = 0; i <= byArray.length - 4; i += n + 4) {
            ZipExtraField zipExtraField;
            object = new ZipShort(byArray, i);
            n = new ZipShort(byArray, i + 2).getValue();
            if (i + 4 + n > byArray.length) {
                switch (unparseableExtraField.getKey()) {
                    case 0: {
                        throw new ZipException("bad extra field starting at " + i + ".  Block length of " + n + " bytes exceeds remaining" + " data of " + (byArray.length - i - 4) + " bytes.");
                    }
                    case 2: {
                        zipExtraField = new UnparseableExtraFieldData();
                        if (bl) {
                            ((UnparseableExtraFieldData)zipExtraField).parseFromLocalFileData(byArray, i, byArray.length - i);
                        } else {
                            ((UnparseableExtraFieldData)zipExtraField).parseFromCentralDirectoryData(byArray, i, byArray.length - i);
                        }
                        arrayList.add(zipExtraField);
                    }
                    case 1: {
                        break block8;
                    }
                    default: {
                        throw new ZipException("unknown UnparseableExtraField key: " + unparseableExtraField.getKey());
                    }
                }
            }
            try {
                zipExtraField = ExtraFieldUtils.createExtraField((ZipShort)object);
                if (bl || !(zipExtraField instanceof CentralDirectoryParsingZipExtraField)) {
                    zipExtraField.parseFromLocalFileData(byArray, i + 4, n);
                } else {
                    ((CentralDirectoryParsingZipExtraField)zipExtraField).parseFromCentralDirectoryData(byArray, i + 4, n);
                }
                arrayList.add(zipExtraField);
                continue;
            }
            catch (InstantiationException instantiationException) {
                throw new ZipException(instantiationException.getMessage());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new ZipException(illegalAccessException.getMessage());
            }
        }
        object = new ZipExtraField[arrayList.size()];
        return arrayList.toArray((T[])object);
    }

    public static byte[] mergeLocalFileDataData(ZipExtraField[] zipExtraFieldArray) {
        boolean bl = zipExtraFieldArray.length > 0 && zipExtraFieldArray[zipExtraFieldArray.length - 1] instanceof UnparseableExtraFieldData;
        int n = bl ? zipExtraFieldArray.length - 1 : zipExtraFieldArray.length;
        int n2 = 4 * n;
        for (int i = 0; i < zipExtraFieldArray.length; ++i) {
            n2 += zipExtraFieldArray[i].getLocalFileDataLength().getValue();
        }
        byte[] byArray = new byte[n2];
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            System.arraycopy(zipExtraFieldArray[i].getHeaderId().getBytes(), 0, byArray, n3, 2);
            System.arraycopy(zipExtraFieldArray[i].getLocalFileDataLength().getBytes(), 0, byArray, n3 + 2, 2);
            byte[] byArray2 = zipExtraFieldArray[i].getLocalFileDataData();
            System.arraycopy(byArray2, 0, byArray, n3 + 4, byArray2.length);
            n3 += byArray2.length + 4;
        }
        if (bl) {
            byte[] byArray3 = zipExtraFieldArray[zipExtraFieldArray.length - 1].getLocalFileDataData();
            System.arraycopy(byArray3, 0, byArray, n3, byArray3.length);
        }
        return byArray;
    }

    public static byte[] mergeCentralDirectoryData(ZipExtraField[] zipExtraFieldArray) {
        boolean bl = zipExtraFieldArray.length > 0 && zipExtraFieldArray[zipExtraFieldArray.length - 1] instanceof UnparseableExtraFieldData;
        int n = bl ? zipExtraFieldArray.length - 1 : zipExtraFieldArray.length;
        int n2 = 4 * n;
        for (int i = 0; i < zipExtraFieldArray.length; ++i) {
            n2 += zipExtraFieldArray[i].getCentralDirectoryLength().getValue();
        }
        byte[] byArray = new byte[n2];
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            System.arraycopy(zipExtraFieldArray[i].getHeaderId().getBytes(), 0, byArray, n3, 2);
            System.arraycopy(zipExtraFieldArray[i].getCentralDirectoryLength().getBytes(), 0, byArray, n3 + 2, 2);
            byte[] byArray2 = zipExtraFieldArray[i].getCentralDirectoryData();
            System.arraycopy(byArray2, 0, byArray, n3 + 4, byArray2.length);
            n3 += byArray2.length + 4;
        }
        if (bl) {
            byte[] byArray3 = zipExtraFieldArray[zipExtraFieldArray.length - 1].getCentralDirectoryData();
            System.arraycopy(byArray3, 0, byArray, n3, byArray3.length);
        }
        return byArray;
    }

    static {
        ExtraFieldUtils.register(AsiExtraField.class);
        ExtraFieldUtils.register(JarMarker.class);
        ExtraFieldUtils.register(UnicodePathExtraField.class);
        ExtraFieldUtils.register(UnicodeCommentExtraField.class);
    }

    public static final class UnparseableExtraField {
        public static final int THROW_KEY = 0;
        public static final int SKIP_KEY = 1;
        public static final int READ_KEY = 2;
        public static final UnparseableExtraField THROW = new UnparseableExtraField(0);
        public static final UnparseableExtraField SKIP = new UnparseableExtraField(1);
        public static final UnparseableExtraField READ = new UnparseableExtraField(2);
        private final int key;

        private UnparseableExtraField(int n) {
            this.key = n;
        }

        public int getKey() {
            return this.key;
        }
    }
}

