/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.zip;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.NoSuchElementException;
import java.util.zip.ZipException;
import org.apache.tools.zip.CentralDirectoryParsingZipExtraField;
import org.apache.tools.zip.ExtraFieldUtils;
import org.apache.tools.zip.UnparseableExtraFieldData;
import org.apache.tools.zip.ZipExtraField;
import org.apache.tools.zip.ZipShort;

public class ZipEntry
extends java.util.zip.ZipEntry
implements Cloneable {
    public static final int PLATFORM_UNIX = 3;
    public static final int PLATFORM_FAT = 0;
    private static final int SHORT_MASK = 65535;
    private static final int SHORT_SHIFT = 16;
    private int internalAttributes = 0;
    private int platform = 0;
    private long externalAttributes = 0L;
    private LinkedHashMap extraFields = null;
    private UnparseableExtraFieldData unparseableExtra = null;
    private String name = null;

    public ZipEntry(String string) {
        super(string);
    }

    public ZipEntry(java.util.zip.ZipEntry zipEntry) throws ZipException {
        super(zipEntry);
        byte[] byArray = zipEntry.getExtra();
        if (byArray != null) {
            this.setExtraFields(ExtraFieldUtils.parse(byArray, true, ExtraFieldUtils.UnparseableExtraField.READ));
        } else {
            this.setExtra();
        }
    }

    public ZipEntry(ZipEntry zipEntry) throws ZipException {
        this((java.util.zip.ZipEntry)zipEntry);
        this.setInternalAttributes(zipEntry.getInternalAttributes());
        this.setExternalAttributes(zipEntry.getExternalAttributes());
        this.setExtraFields(zipEntry.getExtraFields(true));
    }

    protected ZipEntry() {
        super("");
    }

    public Object clone() {
        ZipEntry zipEntry = (ZipEntry)super.clone();
        zipEntry.setInternalAttributes(this.getInternalAttributes());
        zipEntry.setExternalAttributes(this.getExternalAttributes());
        zipEntry.setExtraFields(this.getExtraFields(true));
        return zipEntry;
    }

    public int getInternalAttributes() {
        return this.internalAttributes;
    }

    public void setInternalAttributes(int n) {
        this.internalAttributes = n;
    }

    public long getExternalAttributes() {
        return this.externalAttributes;
    }

    public void setExternalAttributes(long l) {
        this.externalAttributes = l;
    }

    public void setUnixMode(int n) {
        this.setExternalAttributes(n << 16 | ((n & 0x80) == 0 ? 1 : 0) | (this.isDirectory() ? 16 : 0));
        this.platform = 3;
    }

    public int getUnixMode() {
        return this.platform != 3 ? 0 : (int)(this.getExternalAttributes() >> 16 & 0xFFFFL);
    }

    public int getPlatform() {
        return this.platform;
    }

    protected void setPlatform(int n) {
        this.platform = n;
    }

    public void setExtraFields(ZipExtraField[] zipExtraFieldArray) {
        this.extraFields = new LinkedHashMap();
        for (int i = 0; i < zipExtraFieldArray.length; ++i) {
            if (zipExtraFieldArray[i] instanceof UnparseableExtraFieldData) {
                this.unparseableExtra = (UnparseableExtraFieldData)zipExtraFieldArray[i];
                continue;
            }
            this.extraFields.put(zipExtraFieldArray[i].getHeaderId(), zipExtraFieldArray[i]);
        }
        this.setExtra();
    }

    public ZipExtraField[] getExtraFields() {
        return this.getExtraFields(false);
    }

    public ZipExtraField[] getExtraFields(boolean bl) {
        if (this.extraFields == null) {
            ZipExtraField[] zipExtraFieldArray;
            if (!bl || this.unparseableExtra == null) {
                zipExtraFieldArray = new ZipExtraField[]{};
            } else {
                ZipExtraField[] zipExtraFieldArray2 = new ZipExtraField[1];
                zipExtraFieldArray = zipExtraFieldArray2;
                zipExtraFieldArray2[0] = this.unparseableExtra;
            }
            return zipExtraFieldArray;
        }
        ArrayList arrayList = new ArrayList(this.extraFields.values());
        if (bl && this.unparseableExtra != null) {
            arrayList.add(this.unparseableExtra);
        }
        return arrayList.toArray(new ZipExtraField[0]);
    }

    public void addExtraField(ZipExtraField zipExtraField) {
        if (zipExtraField instanceof UnparseableExtraFieldData) {
            this.unparseableExtra = (UnparseableExtraFieldData)zipExtraField;
        } else {
            if (this.extraFields == null) {
                this.extraFields = new LinkedHashMap();
            }
            this.extraFields.put(zipExtraField.getHeaderId(), zipExtraField);
        }
        this.setExtra();
    }

    public void addAsFirstExtraField(ZipExtraField zipExtraField) {
        if (zipExtraField instanceof UnparseableExtraFieldData) {
            this.unparseableExtra = (UnparseableExtraFieldData)zipExtraField;
        } else {
            LinkedHashMap linkedHashMap = this.extraFields;
            this.extraFields = new LinkedHashMap();
            this.extraFields.put(zipExtraField.getHeaderId(), zipExtraField);
            if (linkedHashMap != null) {
                linkedHashMap.remove(zipExtraField.getHeaderId());
                this.extraFields.putAll(linkedHashMap);
            }
        }
        this.setExtra();
    }

    public void removeExtraField(ZipShort zipShort) {
        if (this.extraFields == null) {
            throw new NoSuchElementException();
        }
        if (this.extraFields.remove(zipShort) == null) {
            throw new NoSuchElementException();
        }
        this.setExtra();
    }

    public void removeUnparseableExtraFieldData() {
        if (this.unparseableExtra == null) {
            throw new NoSuchElementException();
        }
        this.unparseableExtra = null;
        this.setExtra();
    }

    public ZipExtraField getExtraField(ZipShort zipShort) {
        if (this.extraFields != null) {
            return (ZipExtraField)this.extraFields.get(zipShort);
        }
        return null;
    }

    public UnparseableExtraFieldData getUnparseableExtraFieldData() {
        return this.unparseableExtra;
    }

    public void setExtra(byte[] byArray) throws RuntimeException {
        try {
            ZipExtraField[] zipExtraFieldArray = ExtraFieldUtils.parse(byArray, true, ExtraFieldUtils.UnparseableExtraField.READ);
            this.mergeExtraFields(zipExtraFieldArray, true);
        }
        catch (Exception exception) {
            throw new RuntimeException("Error parsing extra fields for entry: " + this.getName() + " - " + exception.getMessage(), exception);
        }
    }

    protected void setExtra() {
        super.setExtra(ExtraFieldUtils.mergeLocalFileDataData(this.getExtraFields(true)));
    }

    public void setCentralDirectoryExtra(byte[] byArray) {
        try {
            ZipExtraField[] zipExtraFieldArray = ExtraFieldUtils.parse(byArray, false, ExtraFieldUtils.UnparseableExtraField.READ);
            this.mergeExtraFields(zipExtraFieldArray, false);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage(), exception);
        }
    }

    public byte[] getLocalFileDataExtra() {
        byte[] byArray = this.getExtra();
        return byArray != null ? byArray : new byte[]{};
    }

    public byte[] getCentralDirectoryExtra() {
        return ExtraFieldUtils.mergeCentralDirectoryData(this.getExtraFields(true));
    }

    public void setComprSize(long l) {
        this.setCompressedSize(l);
    }

    public String getName() {
        return this.name == null ? super.getName() : this.name;
    }

    public boolean isDirectory() {
        return this.getName().endsWith("/");
    }

    protected void setName(String string) {
        this.name = string;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object object) {
        return this == object;
    }

    private void mergeExtraFields(ZipExtraField[] zipExtraFieldArray, boolean bl) throws ZipException {
        if (this.extraFields == null) {
            this.setExtraFields(zipExtraFieldArray);
        } else {
            for (int i = 0; i < zipExtraFieldArray.length; ++i) {
                byte[] byArray;
                ZipExtraField zipExtraField = zipExtraFieldArray[i] instanceof UnparseableExtraFieldData ? this.unparseableExtra : this.getExtraField(zipExtraFieldArray[i].getHeaderId());
                if (zipExtraField == null) {
                    this.addExtraField(zipExtraFieldArray[i]);
                    continue;
                }
                if (bl || !(zipExtraField instanceof CentralDirectoryParsingZipExtraField)) {
                    byArray = zipExtraFieldArray[i].getLocalFileDataData();
                    zipExtraField.parseFromLocalFileData(byArray, 0, byArray.length);
                    continue;
                }
                byArray = zipExtraFieldArray[i].getCentralDirectoryData();
                ((CentralDirectoryParsingZipExtraField)zipExtraField).parseFromCentralDirectoryData(byArray, 0, byArray.length);
            }
            this.setExtra();
        }
    }
}

