package charactermanaj.model;

import java.io.Serializable;

public final class PartsIdentifier implements Serializable, Comparable<PartsIdentifier> {

	private static final long serialVersionUID = 8943101890389091718L;

	private final PartsCategory partsCategory;
	
	private final String partsName;
	
	private final String localizedName;
	
	public PartsIdentifier(final PartsCategory partsCategory, final String partsName, final String localizedName) {
		if (partsName == null || partsCategory == null) {
			throw new IllegalArgumentException();
		}
		this.partsCategory = partsCategory;
		this.partsName = partsName;
		this.localizedName = (localizedName == null || localizedName.trim().length() == 0) ? partsName : localizedName;
	}
	
	public PartsCategory getPartsCategory() {
		return partsCategory;
	}
	
	public boolean hasLayer(Layer layer) {
		return partsCategory.hasLayer(layer);
	}
	
	@Override
	public int hashCode() {
		return partsName.hashCode();
	}
	
	@Override
	public boolean equals(Object obj) {
		if (obj == this) {
			return true;
		}
		if (obj != null && obj instanceof PartsIdentifier) {
			return partsName.equals(((PartsIdentifier) obj).partsName);
		}
		return false;
	}
	
	public static boolean equals(PartsIdentifier a, PartsIdentifier b) {
		if (a == b) {
			return true;
		}
		if (a == null || b == null) {
			return false;
		}
		return a.equals(b);
	}
	
	public int compareTo(PartsIdentifier o) {
		if (o == this) {
			return 0;
		}
		int ret = partsCategory.compareTo(o.partsCategory);
		if (ret == 0) {
			ret = localizedName.compareTo(o.localizedName);
		}
		if (ret == 0) {
			ret = partsName.compareTo(o.partsName);
		}
		return ret;
	}
	
	public String getPartsName() {
		return partsName;
	}
	
	public String getLocalizedPartsName() {
		return localizedName;
	}

	@Override
	public String toString() {
		return getLocalizedPartsName();
	}
	
}
