/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model;

import charactermanaj.graphics.io.ImageResource;
import charactermanaj.model.Layer;
import charactermanaj.model.PartsIdentifier;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartsFiles
extends AbstractMap<Layer, ImageResource>
implements Serializable {
    private static final long serialVersionUID = 5799830380308843243L;
    private HashMap<Layer, ImageResource> partsMap = new HashMap();
    private final PartsIdentifier partsIdentifier;

    public PartsFiles(PartsIdentifier partsName) {
        if (partsName == null) {
            throw new IllegalArgumentException();
        }
        this.partsIdentifier = partsName;
    }

    public PartsIdentifier getPartsIdentifier() {
        return this.partsIdentifier;
    }

    @Override
    public Set<Map.Entry<Layer, ImageResource>> entrySet() {
        return Collections.unmodifiableSet(this.partsMap.entrySet());
    }

    @Override
    public ImageResource put(Layer key, ImageResource value) {
        if (key == null || value == null) {
            throw new IllegalArgumentException();
        }
        if (!this.partsIdentifier.hasLayer(key)) {
            throw new IllegalArgumentException(key.toString());
        }
        return this.partsMap.put(key, value);
    }

    @Override
    public ImageResource get(Object key) {
        return this.partsMap.get(key);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.partsMap.containsKey(key);
    }

    public long lastModified() {
        long maxLastModified = 0L;
        for (ImageResource imageResource : this.values()) {
            long lastModified = imageResource.lastModified();
            if (lastModified <= maxLastModified) continue;
            maxLastModified = lastModified;
        }
        return maxLastModified;
    }
}

