/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui.model;

import charactermanaj.graphics.io.ImageResource;
import charactermanaj.ui.Wallpaper;
import charactermanaj.ui.model.WallpaperFactory;
import charactermanaj.ui.model.WallpaperFactoryException;
import charactermanaj.ui.model.WallpaperInfo;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WallpaperFactoryErrorRecoverHandler
implements WallpaperFactory.ErrorHandler {
    protected static final Logger logger = Logger.getLogger(WallpaperFactoryErrorRecoverHandler.class.getName());
    private boolean errorOccured = false;
    private boolean recovered = false;

    public boolean isErrorOccured() {
        return this.errorOccured;
    }

    public boolean isRecovered() {
        return this.recovered;
    }

    public void setErrorOccured(boolean errorOccured) {
        this.errorOccured = errorOccured;
    }

    public void setRecovered(boolean recovered) {
        this.recovered = recovered;
    }

    public File missingImageFile(WallpaperInfo wallpaperInfo, File file) throws WallpaperFactoryException {
        if (file == null) {
            logger.log(Level.FINE, "\u58c1\u7d19\u30d5\u30a1\u30a4\u30eb\u306e\u6307\u5b9a\u304c\u3042\u308a\u307e\u305b\u3093.");
        } else {
            logger.log(Level.WARNING, "\u58c1\u7d19\u30d5\u30a1\u30a4\u30eb\u304c\u5b58\u5728\u3057\u306a\u3044\u304b\u8aad\u307f\u8fbc\u307f\u3067\u304d\u307e\u305b\u3093:" + file);
        }
        wallpaperInfo.setType(WallpaperInfo.WallpaperResourceType.NONE);
        this.setRecovered(true);
        return null;
    }

    public BufferedImage imageCreationFailed(WallpaperInfo wallpaperInfo, ImageResource imageResource, Throwable ex) throws WallpaperFactoryException {
        logger.log(Level.WARNING, "\u58c1\u7d19\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002:" + imageResource, ex);
        wallpaperInfo.setType(WallpaperInfo.WallpaperResourceType.NONE);
        this.setRecovered(true);
        return null;
    }

    public Wallpaper internalError(WallpaperInfo wallpaperInfo, Wallpaper wallpaper, Throwable ex) throws WallpaperFactoryException {
        logger.log(Level.WARNING, "\u58c1\u7d19\u306e\u69cb\u7bc9\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + wallpaperInfo, ex);
        this.setErrorOccured(true);
        throw new WallpaperFactoryException("internal error: " + ex, ex);
    }
}

