/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.graphics.filters;

import charactermanaj.graphics.filters.TableFactory;

public class ContrastTableFactory
implements TableFactory {
    private float contrast = 1.0f;

    public ContrastTableFactory() {
        this(1.0f);
    }

    public ContrastTableFactory(float contrast) {
        this.contrast = contrast;
    }

    @Override
    public int[][] createTable() {
        int[] table = new int[256];
        for (int level = 0; level <= 255; ++level) {
            float f = (float)level / 255.0f;
            int c = (int)((f = this.getContrast(f)) * 256.0f);
            if (c > 255) {
                c = 255;
            } else if (c < 0) {
                c = 0;
            }
            table[level] = c;
        }
        int[][] tables = new int[3][];
        for (int idx = 0; idx < 3; ++idx) {
            tables[idx] = table;
        }
        return tables;
    }

    protected float getContrast(float f) {
        return (f - 0.5f) * this.contrast + 0.5f;
    }
}

