/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.graphics.io;

import charactermanaj.graphics.io.OutputImageBuilderFactory;
import charactermanaj.graphics.io.OutputOption;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.event.IIOWriteWarningListener;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class ImageSaveHelper {
    private static final Logger logger = Logger.getLogger(ImageSaveHelper.class.getName());
    protected static final String STRINGS_RESOURCE = "languages/imageSaveHelper";
    protected static final FileFilter pngFilter = new ImageSaveHelperFilter(){

        @Override
        public String getDescription() {
            return "PNG(*.png)";
        }

        @Override
        protected String[] getSupprotedExtension() {
            return new String[]{"png"};
        }
    };
    protected static final FileFilter jpegFilter = new ImageSaveHelperFilter(){

        @Override
        public String getDescription() {
            return "JPEG(*.jpg;*.jpeg)";
        }

        @Override
        protected String[] getSupprotedExtension() {
            return new String[]{"jpeg", "jpg"};
        }
    };
    protected static final FileFilter bmpFilter = new ImageSaveHelperFilter(){

        @Override
        public String getDescription() {
            return "Bitmap(*.bmp)";
        }

        @Override
        protected String[] getSupprotedExtension() {
            return new String[]{"bmp"};
        }
    };
    protected static final List<FileFilter> fileFilters = Arrays.asList(pngFilter, jpegFilter, bmpFilter);
    protected OutputImageBuilderFactory imageBuilderFactory;
    protected OutputOption outputOption;
    protected File lastUseSaveDir;
    protected FileFilter lastUseFilter = pngFilter;

    public void setLastUseSaveDir(File lastUseSaveDir) {
        this.lastUseSaveDir = lastUseSaveDir;
    }

    public File getLastUsedSaveDir() {
        return this.lastUseSaveDir;
    }

    public ImageSaveHelper() {
        this.imageBuilderFactory = new OutputImageBuilderFactory();
        this.outputOption = this.imageBuilderFactory.createDefaultOutputOption();
    }

    public File showSaveFileDialog(Component parent) {
        JFileChooser fileChooser = new JFileChooser(this.lastUseSaveDir){
            private static final long serialVersionUID = -9091369410030011886L;

            @Override
            public void approveSelection() {
                Properties strings;
                File outFile = this.getSelectedFile();
                if (outFile == null) {
                    return;
                }
                FileFilter selfilter = this.getFileFilter();
                if (selfilter instanceof ImageSaveHelperFilter) {
                    outFile = ((ImageSaveHelperFilter)selfilter).supplyDefaultExtension(this);
                }
                if (outFile.exists() && JOptionPane.showConfirmDialog(this, (strings = LocalizedResourcePropertyLoader.getCachedInstance().getLocalizedProperties(ImageSaveHelper.STRINGS_RESOURCE)).getProperty("confirmOverwrite"), strings.getProperty("confirm"), 0, 2) != 0) {
                    return;
                }
                super.approveSelection();
            }
        };
        fileChooser.setAcceptAllFileFilterUsed(false);
        for (FileFilter fileFilter : fileFilters) {
            fileChooser.addChoosableFileFilter(fileFilter);
        }
        if (this.lastUseFilter == null || !fileFilters.contains(this.lastUseFilter)) {
            this.lastUseFilter = pngFilter;
        }
        fileChooser.setFileFilter(this.lastUseFilter);
        int ret = fileChooser.showSaveDialog(parent);
        if (ret != 0) {
            return null;
        }
        File outFile = fileChooser.getSelectedFile();
        this.lastUseSaveDir = outFile.getParentFile();
        this.lastUseFilter = fileChooser.getFileFilter();
        return outFile;
    }

    public OutputOption getOutputOption() {
        return this.outputOption.clone();
    }

    public void setOutputOption(OutputOption outputOption) {
        if (outputOption == null) {
            throw new IllegalArgumentException();
        }
        this.outputOption = outputOption.clone();
    }

    public void savePicture(BufferedImage img, Color imgBgColor, File outFile, StringBuilder warnings) throws IOException {
        if (img == null || outFile == null) {
            throw new IllegalArgumentException();
        }
        String fname = outFile.getName();
        int extpos = fname.lastIndexOf(".");
        if (extpos < 0) {
            throw new IOException("missing file extension.");
        }
        String ext = fname.substring(extpos + 1).toLowerCase();
        Iterator<ImageWriter> ite = ImageIO.getImageWritersBySuffix(ext);
        if (!ite.hasNext()) {
            throw new IOException("unsupported file extension: " + ext);
        }
        ImageWriter iw = ite.next();
        this.savePicture(img, imgBgColor, iw, outFile, warnings);
    }

    public void savePicture(BufferedImage img, Color imgBgColor, OutputStream outstm, String mime, StringBuilder warnings) throws IOException {
        Iterator<ImageWriter> ite;
        if (img == null || outstm == null || mime == null) {
            throw new IllegalArgumentException();
        }
        int pt = mime.indexOf(59);
        if (pt >= 0) {
            mime = mime.substring(0, pt).trim();
        }
        if (!(ite = ImageIO.getImageWritersByMIMEType(mime)).hasNext()) {
            throw new IOException("unsupported mime: " + mime);
        }
        ImageWriter iw = ite.next();
        this.savePicture(img, imgBgColor, iw, outstm, warnings);
        outstm.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void savePicture(BufferedImage img, Color imgBgColor, ImageWriter iw, Object output, final StringBuilder warnings) throws IOException {
        try {
            IIOImage ioimg;
            iw.addIIOWriteWarningListener(new IIOWriteWarningListener(){

                @Override
                public void warningOccurred(ImageWriter source, int imageIndex, String warning) {
                    if (warnings.length() > 0) {
                        warnings.append(System.getProperty("line.separator"));
                    }
                    if (warnings != null) {
                        warnings.append(warning);
                    }
                    logger.log(Level.WARNING, warning);
                }
            });
            boolean jpeg = false;
            boolean bmp = false;
            for (String mime : iw.getOriginatingProvider().getMIMETypes()) {
                if (mime.contains("image/jpeg") || mime.contains("image/jpg")) {
                    jpeg = true;
                    break;
                }
                if (!mime.contains("image/bmp") && !mime.contains("image/x-bmp") && !mime.contains("image/x-windows-bmp")) continue;
                bmp = true;
                break;
            }
            ImageWriteParam iwp = iw.getDefaultWriteParam();
            if (jpeg) {
                iwp.setCompressionMode(2);
                iwp.setCompressionQuality((float)this.outputOption.getJpegQuality());
                ioimg = new IIOImage(this.createJpegFormatPicture(img, imgBgColor), null, null);
            } else {
                ioimg = bmp ? new IIOImage(this.createBMPFormatPicture(img, imgBgColor), null, null) : (this.outputOption.isForceBgColor() ? new IIOImage(this.createOpaquePNGFormatPicture(img, imgBgColor), null, null) : new IIOImage(img, null, null));
            }
            ImageOutputStream imgstm = ImageIO.createImageOutputStream(output);
            try {
                iw.setOutput(imgstm);
                iw.write(null, ioimg, iwp);
            }
            finally {
                imgstm.close();
            }
        }
        finally {
            iw.dispose();
        }
    }

    public BufferedImage createJpegFormatPicture(BufferedImage img, Color imgBgColor) {
        if (imgBgColor == null) {
            imgBgColor = Color.WHITE;
        }
        return this.createFormatPicture(img, imgBgColor, 4);
    }

    public BufferedImage createBMPFormatPicture(BufferedImage img, Color imgBgColor) {
        if (imgBgColor == null) {
            imgBgColor = Color.WHITE;
        }
        return this.createFormatPicture(img, imgBgColor, 5);
    }

    public BufferedImage createOpaquePNGFormatPicture(BufferedImage img, Color imgBgColor) {
        if (imgBgColor == null) {
            imgBgColor = Color.WHITE;
        }
        return this.createFormatPicture(img, imgBgColor, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BufferedImage createFormatPicture(BufferedImage img, Color imgBgColor, int type) {
        if (img == null) {
            throw new IllegalArgumentException();
        }
        int w = img.getWidth();
        int h = img.getHeight();
        BufferedImage tmpImg = new BufferedImage(w, h, type);
        Graphics2D g = tmpImg.createGraphics();
        try {
            g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
            if (imgBgColor != null) {
                g.setColor(imgBgColor);
                g.fillRect(0, 0, w, h);
            }
            g.drawImage(img, 0, 0, w, h, 0, 0, w, h, null);
        }
        finally {
            g.dispose();
        }
        return tmpImg;
    }

    protected static abstract class ImageSaveHelperFilter
    extends FileFilter {
        protected ImageSaveHelperFilter() {
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            return this.isSupported(f);
        }

        protected boolean isSupported(File f) {
            String lcName = f.getName().toLowerCase();
            for (String ext : this.getSupprotedExtension()) {
                if (!lcName.endsWith("." + ext.toLowerCase())) continue;
                return true;
            }
            return false;
        }

        public File supplyDefaultExtension(JFileChooser fileChooser) {
            File outFile = fileChooser.getSelectedFile();
            if (outFile == null) {
                return null;
            }
            if (!this.isSupported(outFile)) {
                String extName = "." + this.getSupprotedExtension()[0];
                outFile = new File(outFile.getPath() + extName);
                fileChooser.setSelectedFile(outFile);
            }
            return outFile;
        }

        protected abstract String[] getSupprotedExtension();
    }
}

