/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model.io;

import charactermanaj.model.CharacterData;
import charactermanaj.model.CustomLayerOrder;
import charactermanaj.model.CustomLayerOrderKey;
import charactermanaj.model.io.CustomLayerOrderXMLPersist;
import java.io.IOException;
import java.net.URI;
import java.util.EventListener;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

public abstract class CustomLayerOrderPersist {
    protected final CharacterData characterData;
    private static final Map<URI, Queue<CustomLayerOrderPersistListener>> listenersMap = new ConcurrentHashMap<URI, Queue<CustomLayerOrderPersistListener>>();

    protected CustomLayerOrderPersist(CharacterData characterData) {
        if (characterData == null) {
            throw new NullPointerException();
        }
        this.characterData = characterData;
    }

    public CharacterData getCharacterData() {
        return this.characterData;
    }

    public static CustomLayerOrderPersist newInstance(CharacterData characterData) {
        return new CustomLayerOrderXMLPersist(characterData);
    }

    public abstract boolean exist();

    public abstract void save(Map<CustomLayerOrderKey, List<CustomLayerOrder>> var1) throws IOException;

    public abstract Map<CustomLayerOrderKey, List<CustomLayerOrder>> load() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCustomLayerOrderPersistListener(CustomLayerOrderPersistListener l) {
        URI uri = this.characterData.getDocBase();
        if (l != null && uri != null) {
            Map<URI, Queue<CustomLayerOrderPersistListener>> map = listenersMap;
            synchronized (map) {
                Queue<CustomLayerOrderPersistListener> listeners = listenersMap.get(uri);
                if (listeners == null) {
                    listeners = new ConcurrentLinkedQueue<CustomLayerOrderPersistListener>();
                    listenersMap.put(uri, listeners);
                }
                listeners.add(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCustomLayerOrderPersistListener(CustomLayerOrderPersistListener l) {
        URI uri = this.characterData.getDocBase();
        if (l != null && uri != null) {
            Map<URI, Queue<CustomLayerOrderPersistListener>> map = listenersMap;
            synchronized (map) {
                Queue<CustomLayerOrderPersistListener> listeners = listenersMap.get(uri);
                if (listeners != null) {
                    listeners.remove(l);
                    if (listeners.isEmpty()) {
                        listenersMap.remove(uri);
                    }
                }
            }
        }
    }

    protected void fireEvent(Map<CustomLayerOrderKey, List<CustomLayerOrder>> map) {
        Queue<CustomLayerOrderPersistListener> listeners;
        URI uri = this.characterData.getDocBase();
        if (uri != null && (listeners = listenersMap.get(uri)) != null) {
            CustomLayerOrderPersistListener.Change e = new CustomLayerOrderPersistListener.Change(this.characterData, map);
            for (CustomLayerOrderPersistListener l : listeners) {
                l.notifyChangeCustomLayerOrder(e);
            }
        }
    }

    public static interface CustomLayerOrderPersistListener
    extends EventListener {
        public void notifyChangeCustomLayerOrder(Change var1);

        public static class Change
        extends EventObject {
            private static final long serialVersionUID = 9176040093651262447L;
            private Map<CustomLayerOrderKey, List<CustomLayerOrder>> customLayerOrderMap;

            public Change(CharacterData characterData, Map<CustomLayerOrderKey, List<CustomLayerOrder>> customLayerOrderMap) {
                super(characterData);
                this.customLayerOrderMap = customLayerOrderMap;
            }

            @Override
            public CharacterData getSource() {
                return (CharacterData)super.getSource();
            }

            public Map<CustomLayerOrderKey, List<CustomLayerOrder>> getCustomLayerOrderMap() {
                return this.customLayerOrderMap;
            }
        }
    }
}

