/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model.io;

import charactermanaj.model.AppConfig;
import charactermanaj.model.CharacterData;
import charactermanaj.model.PartsAuthorInfo;
import charactermanaj.model.PartsCategory;
import charactermanaj.model.PartsManageData;
import charactermanaj.model.io.AbstractCharacterDataArchiveFile;
import charactermanaj.model.io.CharacterDataArchiveFile;
import charactermanaj.model.io.CharacterDataFileReaderWriterFactory;
import charactermanaj.model.io.PartsInfoXMLReader;
import charactermanaj.model.io.PartsInfoXMLWriter;
import charactermanaj.ui.progress.ProgressHandle;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ImportModel {
    private static final Logger logger = Logger.getLogger(ImportModel.class.getName());
    private URI importSource;
    private CharacterData currentCharacterData;
    private CharacterDataArchiveFile archiveFile;
    private CharacterData sourceCharacterData;
    private BufferedImage samplePicture;
    private String readme;
    private Collection<AbstractCharacterDataArchiveFile.PartsImageContent> partsImageContentsMap;
    private PartsManageData partsManageData;

    public void openImportSource(URI importSource, CharacterData currentCharacterData) throws IOException {
        if (this.archiveFile != null || importSource == null) {
            throw new IllegalStateException("\u65e2\u306b\u30a2\u30fc\u30ab\u30a4\u30d6\u304c\u30aa\u30fc\u30d7\u30f3\u3055\u308c\u3066\u3044\u307e\u3059\u3002");
        }
        this.importSource = importSource;
        this.currentCharacterData = currentCharacterData;
    }

    public void closeImportSource() throws IOException {
        if (this.archiveFile != null) {
            try {
                this.archiveFile.close();
            }
            finally {
                this.reset();
            }
        }
    }

    public void loadContents(ProgressHandle progressHandle) throws IOException {
        if (this.archiveFile != null) {
            throw new IllegalStateException("\u65e2\u306b\u30a2\u30fc\u30ab\u30a4\u30d6\u304c\u30aa\u30fc\u30d7\u30f3\u3055\u308c\u3066\u3044\u307e\u3059\u3002");
        }
        if (this.importSource == null) {
            throw new IllegalStateException("\u30a4\u30f3\u30dd\u30fc\u30c8\u30d5\u30a1\u30a3\u30eb\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        CharacterDataFileReaderWriterFactory factory = CharacterDataFileReaderWriterFactory.getInstance();
        progressHandle.setCaption("open archive...");
        this.archiveFile = factory.openArchive(this.importSource);
        this.readme = this.archiveFile.readReadMe();
        progressHandle.setCaption("search the character definition...");
        this.sourceCharacterData = this.archiveFile.readCharacterData();
        if (this.sourceCharacterData == null) {
            this.sourceCharacterData = this.archiveFile.readCharacterINI();
            if (this.sourceCharacterData != null && this.readme != null && this.readme.trim().length() > 0) {
                this.sourceCharacterData.setDescription(this.readme);
            }
        } else {
            this.archiveFile.readFavorites(this.sourceCharacterData);
        }
        progressHandle.setCaption("load sample picture...");
        this.samplePicture = this.archiveFile.readSamplePicture();
        progressHandle.setCaption("load partssets...");
        this.partsImageContentsMap = this.currentCharacterData != null ? this.archiveFile.getPartsImageContents(this.currentCharacterData, false) : this.archiveFile.getPartsImageContents(this.sourceCharacterData, true);
        progressHandle.setCaption("load parts definitions...");
        this.partsManageData = this.archiveFile.getPartsManageData();
    }

    protected void reset() {
        this.importSource = null;
        this.archiveFile = null;
        this.sourceCharacterData = null;
        this.samplePicture = null;
        this.readme = null;
        this.partsImageContentsMap = null;
        this.partsManageData = null;
    }

    public URI getImportSource() {
        return this.importSource;
    }

    protected void checkArchiveOpened() {
        if (this.archiveFile == null) {
            throw new IllegalStateException("\u30a2\u30fc\u30ab\u30a4\u30d6\u306f\u30aa\u30fc\u30d7\u30f3\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
    }

    public CharacterData getCharacterData() {
        this.checkArchiveOpened();
        return this.sourceCharacterData;
    }

    public BufferedImage getSamplePicture() {
        this.checkArchiveOpened();
        return this.samplePicture;
    }

    public String getReadme() {
        this.checkArchiveOpened();
        return this.readme;
    }

    public Collection<AbstractCharacterDataArchiveFile.PartsImageContent> getPartsImageContents() {
        this.checkArchiveOpened();
        return this.partsImageContentsMap;
    }

    public PartsManageData getPartsManageData() {
        this.checkArchiveOpened();
        return this.partsManageData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyPartsImageContents(Collection<AbstractCharacterDataArchiveFile.PartsImageContent> partsImageContents, CharacterData cd) throws IOException {
        if (cd == null || cd.getDocBase() == null) {
            throw new IllegalArgumentException("invalid character data");
        }
        URI docbase = cd.getDocBase();
        if (!"file".equals(docbase.getScheme())) {
            throw new IOException("\u30d5\u30a1\u30a4\u30eb\u4ee5\u5916\u306f\u30b5\u30dd\u30fc\u30c8\u3057\u3066\u3044\u307e\u305b\u3093: " + docbase);
        }
        File configFile = new File(docbase);
        File baseDir = configFile.getParentFile();
        if (baseDir == null || !baseDir.isDirectory()) {
            throw new IOException("\u89aa\u30d5\u30a9\u30eb\u30c0\u304c\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3067\u306f\u3042\u308a\u307e\u305b\u3093: " + baseDir);
        }
        AppConfig appConfig = AppConfig.getInstance();
        byte[] stmbuf = new byte[appConfig.getFileTransferBufferSize()];
        for (AbstractCharacterDataArchiveFile.PartsImageContent content : partsImageContents) {
            BufferedInputStream is = new BufferedInputStream(content.openStream());
            try {
                File outDir = new File(baseDir, content.getDirName());
                if (!outDir.exists() && !outDir.mkdirs()) {
                    logger.log(Level.WARNING, "can't create the directory. " + outDir);
                }
                File outFile = new File(outDir, content.getFileName());
                BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(outFile));
                try {
                    int rd;
                    while ((rd = ((InputStream)is).read(stmbuf)) >= 0) {
                        ((OutputStream)os).write(stmbuf, 0, rd);
                    }
                }
                finally {
                    ((OutputStream)os).close();
                }
                if (outFile.setLastModified(content.lastModified())) continue;
                logger.log(Level.WARNING, "can't change the modified-date: " + outFile);
            }
            finally {
                ((InputStream)is).close();
            }
        }
    }

    public void updatePartsManageData(Collection<AbstractCharacterDataArchiveFile.PartsImageContent> partsImageContents, PartsManageData partsManageData, CharacterData current, CharacterData target) throws IOException {
        if (target == null || !target.isValid()) {
            throw new IllegalArgumentException();
        }
        if (partsImageContents == null || partsImageContents.isEmpty() || partsManageData == null || partsManageData.isEmpty()) {
            return;
        }
        PartsInfoXMLReader xmlReader = new PartsInfoXMLReader();
        PartsManageData mergedPartsManagedData = current != null && current.isValid() ? xmlReader.loadPartsManageData(current.getDocBase()) : new PartsManageData();
        for (AbstractCharacterDataArchiveFile.PartsImageContent partsImageContent : partsImageContents) {
            String partsName = partsImageContent.getPartsName();
            for (AbstractCharacterDataArchiveFile.CategoryLayerPair catLayerPair : partsImageContent.getCategoryLayerPairs()) {
                PartsCategory partsCategory = catLayerPair.getPartsCategory();
                String categoryId = partsCategory.getCategoryId();
                PartsManageData.PartsKey partsKey = new PartsManageData.PartsKey(partsName, categoryId);
                PartsAuthorInfo partsAuthorInfo = partsManageData.getPartsAuthorInfo(partsKey);
                PartsManageData.PartsVersionInfo versionInfo = partsManageData.getVersion(partsKey);
                String localizedName = partsManageData.getLocalizedName(partsKey);
                if (partsAuthorInfo == null && versionInfo == null && localizedName == null) continue;
                mergedPartsManagedData.putPartsInfo(partsKey, localizedName, partsAuthorInfo, versionInfo);
            }
        }
        PartsInfoXMLWriter partsInfoXMLWriter = new PartsInfoXMLWriter();
        partsInfoXMLWriter.savePartsManageData(target.getDocBase(), mergedPartsManagedData);
    }
}

