/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.util.LocalizedResourcePropertyLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JPanel;

public class ColorBox
extends JPanel {
    private static final long serialVersionUID = -8745278154296281466L;
    protected static final String STRINGS_RESOURCE = "languages/colorbox";
    private String actionCommand = "colorKey";
    private Color colorKey;
    private JPanel colorDisplayPanel;
    private AbstractAction actChooseColor;

    public ColorBox() {
        this((Color)null, true);
    }

    public ColorBox(Color colorKey, boolean colorPicker) {
        if (colorKey == null) {
            colorKey = Color.WHITE;
        }
        this.colorKey = colorKey;
        Properties strings = LocalizedResourcePropertyLoader.getCachedInstance().getLocalizedProperties(STRINGS_RESOURCE);
        this.colorDisplayPanel = this.createColorDiaplyPanel();
        this.colorDisplayPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (ColorBox.this.actChooseColor.isEnabled() && e.getClickCount() == 2) {
                    ColorBox.this.onChooseColor(new ActionEvent(this, 1, ColorBox.this.getActionCommand(), e.getWhen(), e.getModifiers()));
                }
            }
        });
        this.colorDisplayPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 0, 0, 3), BorderFactory.createBevelBorder(1)));
        this.colorDisplayPanel.setPreferredSize(new Dimension(32, 24));
        this.actChooseColor = new AbstractAction(strings.getProperty("btn.chooseColorKey")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorBox.this.onChooseColor(e);
            }
        };
        JButton btnChooseColor = new JButton(this.actChooseColor);
        btnChooseColor.setVisible(colorPicker);
        this.actChooseColor.setEnabled(colorPicker);
        this.setLayout(new BorderLayout());
        this.add((Component)this.colorDisplayPanel, "Center");
        this.add((Component)btnChooseColor, "East");
    }

    protected JPanel createColorDiaplyPanel() {
        return new JPanel(){
            private static final long serialVersionUID = -8554046012311330274L;

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                Rectangle rct = this.getBounds();
                Insets insets = this.getInsets();
                int x = insets.left;
                int y = insets.top;
                int w = rct.width - insets.left - insets.right;
                int h = rct.height - insets.top - insets.bottom;
                g.setColor(ColorBox.this.getColorKey());
                g.fillRect(x, y, w, h);
            }
        };
    }

    protected JPanel getColorDisplayPanel() {
        return this.colorDisplayPanel;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.actChooseColor.setEnabled(enabled);
    }

    public void setColorKey(Color colorKey) {
        if (colorKey == null) {
            colorKey = Color.WHITE;
        }
        if (!this.colorKey.equals(colorKey)) {
            Color oldc = this.colorKey;
            this.colorKey = colorKey;
            this.repaint();
            this.firePropertyChange("colorKey", oldc, colorKey);
        }
    }

    public void addActionListener(ActionListener l) {
        this.listenerList.add(ActionListener.class, l);
    }

    public void removeActionListener(ActionListener l) {
        this.listenerList.remove(ActionListener.class, l);
    }

    protected void fireActionPerformed(ActionEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        ActionEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ActionListener.class) continue;
            if (e == null) {
                String actionCommand = event.getActionCommand();
                if (actionCommand == null) {
                    actionCommand = this.getActionCommand();
                }
                e = new ActionEvent(this, 1001, actionCommand, event.getWhen(), event.getModifiers());
            }
            ((ActionListener)listeners[i + 1]).actionPerformed(e);
        }
    }

    public void setActionCommand(String actionCommand) {
        this.actionCommand = actionCommand;
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public Color getColorKey() {
        return this.colorKey;
    }

    protected String getColorDialogTitle() {
        Properties strings = LocalizedResourcePropertyLoader.getCachedInstance().getLocalizedProperties(STRINGS_RESOURCE);
        return strings.getProperty("caption.chooseColorKey");
    }

    protected void onChooseColor(ActionEvent e) {
        Color colorKey = this.getColorKey();
        colorKey = JColorChooser.showDialog(this, this.getColorDialogTitle(), colorKey);
        if (colorKey != null) {
            this.setColorKey(colorKey);
            this.fireActionPerformed(e);
        }
    }
}

