/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;

class ColorCell
extends JPanel {
    private static final long serialVersionUID = 1L;
    private String title = "Color";
    private JPanel box;
    private JLabel label;
    private JButton button;
    private ActionListener actionListener;
    private Color selectedColor;

    public ColorCell() {
        this((ActionListener)null);
    }

    public ColorCell(ActionListener actionListener) {
        super(new BorderLayout());
        this.actionListener = actionListener;
        this.box = new JPanel(new BorderLayout());
        this.label = new JLabel();
        this.label.setHorizontalAlignment(0);
        this.box.add((Component)this.label, "Center");
        this.box.setBorder(BorderFactory.createEtchedBorder());
        this.button = new JButton();
        Dimension dim = this.button.getPreferredSize();
        dim.width = 24;
        this.button.setPreferredSize(dim);
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorCell.this.onClick(e);
            }
        });
        this.add((Component)this.box, "Center");
        this.add((Component)this.button, "East");
        this.setSelectedColor(Color.BLACK);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        String old = this.title;
        if (old == null ? title != null : !old.equals(title)) {
            this.title = title;
            this.firePropertyChange("title", old, title);
        }
    }

    protected void onClick(ActionEvent e) {
        Color selColor = JColorChooser.showDialog(this, this.title, this.selectedColor);
        if (selColor != null) {
            this.setSelectedColor(selColor);
            if (this.actionListener != null) {
                this.actionListener.actionPerformed(e);
            }
        }
    }

    public Color getSelectedColor() {
        return this.selectedColor;
    }

    public void setSelectedColor(Color color) {
        Color old;
        if (color == null) {
            color = Color.BLACK;
        }
        if ((old = this.selectedColor) == null ? color != null : !old.equals(color)) {
            Color premultipliedColor;
            this.selectedColor = color;
            Color colorForeground = new Color(color.getRGB() ^ 0xFFFFFF).brighter();
            int alpha = color.getAlpha();
            if (alpha == 255) {
                premultipliedColor = color;
            } else {
                float[] rgb = color.getRGBColorComponents(null);
                float[] bgRgb = Color.WHITE.getRGBColorComponents(null);
                float a = (float)alpha / 255.0f;
                rgb[0] = rgb[0] * a + bgRgb[0] * (1.0f - a);
                rgb[1] = rgb[1] * a + bgRgb[1] * (1.0f - a);
                rgb[2] = rgb[2] * a + bgRgb[2] * (1.0f - a);
                premultipliedColor = new Color(rgb[0], rgb[1], rgb[2]);
            }
            this.box.setBackground(premultipliedColor);
            this.label.setForeground(colorForeground);
            String msg = alpha != 255 ? String.format("#%08X", (long)color.getRGB() & 0xFFFFFFFFL) : String.format("#%06X", (long)color.getRGB() & 0xFFFFFFL);
            this.label.setText(msg);
            this.firePropertyChange("selectedColor", old, color);
        }
    }
}

