/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.Main;
import charactermanaj.graphics.filters.ColorConv;
import charactermanaj.graphics.filters.ColorConvertParameter;
import charactermanaj.model.AppConfig;
import charactermanaj.model.ColorGroup;
import charactermanaj.model.Layer;
import charactermanaj.model.PartsCategory;
import charactermanaj.model.PartsIdentifier;
import charactermanaj.ui.ColorDialogTabPanel;
import charactermanaj.ui.model.ColorChangeEvent;
import charactermanaj.ui.model.ColorChangeListener;
import charactermanaj.util.ErrorMessageHelper;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import charactermanaj.util.UIHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Semaphore;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.EventListenerList;

public class ColorDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(ColorDialog.class.getName());
    private final PartsCategory partsCategory;
    private HashMap<Layer, ColorDialogTabPanel> tabs = new HashMap();
    private JTabbedPane tabbedPane;
    private HashMap<Layer, Integer> tabbedPaneIndexMap = new HashMap();
    private final EventListenerList listeners = new EventListenerList();
    private String captionBase;
    private PartsIdentifier partsIdentifier;
    private JCheckBox chkApplyAll;
    private Action actReset;
    private JCheckBox chkShowAdvancedSettings;

    public ColorDialog(JFrame parent, PartsCategory partsCategory, Collection<ColorGroup> colorGroups) {
        super(parent);
        this.partsCategory = partsCategory;
        Properties strings = LocalizedResourcePropertyLoader.getCachedInstance().getLocalizedProperties("languages/colordialog");
        String caption = strings.getProperty("colordialog.caption");
        String name = partsCategory.getLocalizedCategoryName();
        this.captionBase = caption + name;
        this.setTitle(this.captionBase);
        final AbstractAction actHide = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorDialog.this.setVisible(false);
            }
        };
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                actHide.actionPerformed(new ActionEvent(ColorDialog.this, 0, "closing"));
            }
        });
        Container container = this.getContentPane();
        this.tabbedPane = new JTabbedPane(1, 0);
        for (final Layer layer : partsCategory.getLayers()) {
            final ColorDialogTabPanel tabContainer = new ColorDialogTabPanel(this, layer, colorGroups);
            ColorChangeListener innerListener = new ColorChangeListener(){
                private Semaphore semaphore = new Semaphore(1);

                @Override
                public void onColorChange(ColorChangeEvent event) {
                    if (this.semaphore.tryAcquire()) {
                        try {
                            ColorDialog.this.fireColorChangeEvent(layer, false);
                        }
                        finally {
                            this.semaphore.release();
                        }
                    }
                }

                @Override
                public void onColorGroupChange(ColorChangeEvent event) {
                    if (this.semaphore.tryAcquire()) {
                        try {
                            ColorDialog.this.fireColorGroupChangeEvent(layer);
                            ColorDialog.this.fireColorChangeEvent(layer, false);
                        }
                        finally {
                            this.semaphore.release();
                        }
                    }
                }
            };
            tabContainer.addColorChangeListener(innerListener);
            tabContainer.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentShown(ComponentEvent e) {
                    ColorDialog.this.updateResetButton(tabContainer);
                }
            });
            tabContainer.addPropertyChangeListener("colorConvertParameter", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    ColorDialog.this.updateResetButton(tabContainer);
                }
            });
            this.tabbedPane.addTab(layer.getLocalizedName(), tabContainer);
            this.tabbedPaneIndexMap.put(layer, this.tabbedPane.getTabCount() - 1);
            this.tabs.put(layer, tabContainer);
        }
        AbstractAction actApply = new AbstractAction(strings.getProperty("button.apply")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorDialog.this.apply();
            }
        };
        this.actReset = new AbstractAction(strings.getProperty("button.reset")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorDialogTabPanel tab = (ColorDialogTabPanel)ColorDialog.this.tabbedPane.getSelectedComponent();
                if (tab != null) {
                    ColorDialog.this.resetColor(tab);
                    ColorDialog.this.apply();
                }
            }
        };
        JPanel btnPanel = new JPanel();
        btnPanel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        GridBagLayout gbl = new GridBagLayout();
        btnPanel.setLayout(gbl);
        int colIdx = 0;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = colIdx++;
        gbc.gridy = 0;
        gbc.ipadx = 0;
        gbc.ipady = 0;
        gbc.anchor = 13;
        gbc.fill = 1;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        this.chkApplyAll = new JCheckBox(strings.getProperty("checkbox.applyAllItems"));
        this.chkApplyAll.setSelected(!partsCategory.isMultipleSelectable());
        this.chkApplyAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorDialog.this.apply();
            }
        });
        btnPanel.add((Component)this.chkApplyAll, gbc);
        gbc.gridx = colIdx++;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        btnPanel.add(Box.createHorizontalGlue(), gbc);
        JButton btnApply = null;
        AppConfig appConfig = AppConfig.getInstance();
        if (!appConfig.isEnableAutoColorChange()) {
            gbc.gridx = colIdx++;
            gbc.gridy = 0;
            gbc.weightx = 0.0;
            btnApply = new JButton(actApply);
            btnPanel.add((Component)btnApply, gbc);
        }
        gbc.gridx = colIdx++;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        JButton btnReset = new JButton(this.actReset);
        btnPanel.add((Component)btnReset, gbc);
        UIHelper uiUtl = UIHelper.getInstance();
        JButton copyBtn = uiUtl.createIconButton("icons/copy.png");
        JButton pasteBtn = uiUtl.createIconButton("icons/paste.png");
        copyBtn.setToolTipText(strings.getProperty("copy"));
        pasteBtn.setToolTipText(strings.getProperty("paste"));
        AbstractAction actCopy = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean shift = (e.getModifiers() & 1) != 0;
                ColorDialog.this.onCopy(shift);
            }
        };
        AbstractAction actPaste = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorDialog.this.onPaste();
            }
        };
        copyBtn.addActionListener(actCopy);
        pasteBtn.addActionListener(actPaste);
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        toolBar.add(copyBtn);
        toolBar.add(pasteBtn);
        AbstractAction actShowAdvancedSetting = new AbstractAction(strings.getProperty("chk.showAdvancedSettings")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorDialog.this.onChangeShowAdvancedSettings();
            }
        };
        this.chkShowAdvancedSettings = new JCheckBox(actShowAdvancedSetting);
        this.chkShowAdvancedSettings.setSelected(appConfig.isEnableColorAdvancedSettings());
        this.onChangeShowAdvancedSettings();
        Box btns = Box.createHorizontalBox();
        btns.add(this.chkShowAdvancedSettings);
        btns.add(Box.createHorizontalGlue());
        btns.add(toolBar);
        container.setLayout(new BorderLayout());
        container.add((Component)btns, "North");
        container.add((Component)this.tabbedPane, "Center");
        container.add((Component)btnPanel, "South");
        Toolkit tk = Toolkit.getDefaultToolkit();
        JRootPane rootPane = this.getRootPane();
        if (btnApply != null) {
            rootPane.setDefaultButton(btnApply);
        }
        InputMap im = rootPane.getInputMap(2);
        ActionMap am = rootPane.getActionMap();
        int ctrlMask = tk.getMenuShortcutKeyMask();
        im.put(KeyStroke.getKeyStroke(87, ctrlMask), "hideColorDialog");
        am.put("hideColorDialog", actHide);
        im.put(KeyStroke.getKeyStroke(67, ctrlMask + 1), "copyColorParam");
        am.put("copyColorParam", actCopy);
        im.put(KeyStroke.getKeyStroke(86, ctrlMask + 1), "pastColorParam");
        am.put("pastColorParam", actPaste);
        im.put(KeyStroke.getKeyStroke(69, ctrlMask), "showAdvancedSetting");
        am.put("showAdvancedSetting", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorDialog.this.chkShowAdvancedSettings.setSelected(!ColorDialog.this.chkShowAdvancedSettings.isSelected());
                ColorDialog.this.onChangeShowAdvancedSettings();
            }
        });
        this.pack();
    }

    protected void onChangeShowAdvancedSettings() {
        boolean show = this.chkShowAdvancedSettings.isSelected();
        for (ColorDialogTabPanel tabContainer : this.tabs.values()) {
            tabContainer.setVisibleAdvancedSettings(show);
        }
        this.pack();
    }

    protected void onCopy(boolean advanced) {
        Toolkit tk = Toolkit.getDefaultToolkit();
        ColorDialogTabPanel tabContainer = (ColorDialogTabPanel)this.tabbedPane.getSelectedComponent();
        if (tabContainer == null) {
            tk.beep();
            return;
        }
        ColorConvertParameter param = tabContainer.getColorConvertParameter();
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        if (this.partsIdentifier != null) {
            pw.println("# " + this.partsIdentifier.getLocalizedPartsName());
        }
        pw.println("# " + this.partsCategory.getLocalizedCategoryName());
        pw.println("# " + tabContainer.getLayer().getLocalizedName());
        pw.println();
        pw.println("hue=" + param.getHue());
        pw.println("saturation=" + param.getSaturation());
        pw.println("brightness=" + param.getBrightness());
        pw.println("contrast=" + param.getContrast());
        if (advanced) {
            pw.println();
            pw.println("offsetR=" + param.getOffsetR());
            pw.println("offsetG=" + param.getOffsetG());
            pw.println("offsetB=" + param.getOffsetB());
            pw.println("offsetA=" + param.getOffsetA());
            pw.println("factorR=" + param.getFactorR());
            pw.println("factorG=" + param.getFactorG());
            pw.println("factorB=" + param.getFactorB());
            pw.println("factorA=" + param.getFactorA());
            pw.println("gammaR=" + param.getGammaR());
            pw.println("gammaG=" + param.getGammaG());
            pw.println("gammaB=" + param.getGammaB());
            pw.println("gammaA=" + param.getGammaA());
            pw.println("grayLevel=" + param.getGrayLevel());
            pw.println("replace=" + param.getColorReplace());
        }
        Clipboard cb = tk.getSystemClipboard();
        StringSelection selection = new StringSelection(sw.toString());
        cb.setContents(selection, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onPaste() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        ColorDialogTabPanel tabContainer = (ColorDialogTabPanel)this.tabbedPane.getSelectedComponent();
        if (tabContainer == null) {
            tk.beep();
            return;
        }
        Clipboard cb = tk.getSystemClipboard();
        Transferable trans = cb.getContents(null);
        if (trans == null) {
            tk.beep();
            return;
        }
        try {
            ArrayList<String> errorLines;
            ColorConvertParameter org;
            ColorConvertParameter param;
            block36: {
                DataFlavor[] flavors = trans.getTransferDataFlavors();
                DataFlavor textFlavor = DataFlavor.selectBestTextFlavor(flavors);
                if (textFlavor == null) {
                    tk.beep();
                    return;
                }
                param = tabContainer.getColorConvertParameter();
                org = param.clone();
                errorLines = new ArrayList<String>();
                BufferedReader rd = new BufferedReader(textFlavor.getReaderForText(trans));
                block7: while (true) {
                    while (true) {
                        String line;
                        if ((line = rd.readLine()) == null) {
                            break block36;
                        }
                        int pt = line.indexOf(35);
                        if (pt >= 0) {
                            line = line.substring(0, pt);
                        }
                        if ((line = line.trim()).isEmpty()) continue;
                        String[] tokens = line.split("=");
                        if (tokens.length == 2) {
                            String name = ((String)tokens[0]).trim().toLowerCase();
                            String val = ((String)tokens[1]).trim();
                            try {
                                if ("hue".equals(name)) {
                                    param.setHue(Float.parseFloat(val));
                                    continue block7;
                                }
                                if ("saturation".equals(name)) {
                                    param.setSaturation(Float.parseFloat(val));
                                    continue block7;
                                }
                                if ("brightness".equals(name)) {
                                    param.setBrightness(Float.parseFloat(val));
                                    continue block7;
                                }
                                if ("contrast".equals(name)) {
                                    param.setContrast(Float.parseFloat(val));
                                    continue block7;
                                }
                                if ("offsetr".equals(name)) {
                                    param.setOffsetR(Integer.parseInt(val));
                                    continue block7;
                                }
                                if ("offsetg".equals(name)) {
                                    param.setOffsetG(Integer.parseInt(val));
                                    continue block7;
                                }
                                if ("offsetb".equals(name)) {
                                    param.setOffsetB(Integer.parseInt(val));
                                    continue block7;
                                }
                                if ("offseta".equals(name)) {
                                    param.setOffsetA(Integer.parseInt(val));
                                    continue block7;
                                }
                                if ("factorr".equals(name)) {
                                    param.setFactorR(Float.parseFloat(val));
                                    continue block7;
                                }
                                if ("factorg".equals(name)) {
                                    param.setFactorG(Float.parseFloat(val));
                                    continue block7;
                                }
                                if ("factorb".equals(name)) {
                                    param.setFactorB(Float.parseFloat(val));
                                    continue block7;
                                }
                                if ("factora".equals(name)) {
                                    param.setFactorA(Float.parseFloat(val));
                                    continue block7;
                                }
                                if ("gammar".equals(name)) {
                                    param.setGammaR(Float.parseFloat(val));
                                    continue block7;
                                }
                                if ("gammag".equals(name)) {
                                    param.setGammaG(Float.parseFloat(val));
                                    continue block7;
                                }
                                if ("gammab".equals(name)) {
                                    param.setGammaB(Float.parseFloat(val));
                                    continue block7;
                                }
                                if ("gammaa".equals(name)) {
                                    param.setGammaA(Float.parseFloat(val));
                                    continue block7;
                                }
                                if ("graylevel".equals(name)) {
                                    param.setGrayLevel(Float.parseFloat(val));
                                    continue block7;
                                }
                                if ("replace".equals(name)) {
                                    param.setColorReplace(ColorConv.valueOf(val));
                                    continue block7;
                                }
                                errorLines.add(line);
                                continue block7;
                            }
                            catch (RuntimeException ex) {
                                logger.log(Level.WARNING, "failed to read the clipboard.", ex);
                                errorLines.add(line);
                                errorLines.add("* " + ex.toString());
                                continue;
                            }
                        }
                        errorLines.add(line);
                    }
                    break;
                }
                finally {
                    rd.close();
                }
            }
            if (!param.equals(org)) {
                tabContainer.applyColorConvertParameter(param);
            }
            if (errorLines.size() > 0) {
                StringBuilder buf = new StringBuilder();
                String lineBreak = System.getProperty("line.separator");
                for (String line : errorLines) {
                    buf.append(line).append(lineBreak);
                }
                JTextArea message = new JTextArea(buf.toString());
                message.setEditable(false);
                JScrollPane scr = new JScrollPane(message);
                scr.setPreferredSize(new Dimension(200, 200));
                Properties strings = LocalizedResourcePropertyLoader.getCachedInstance().getLocalizedProperties("languages/colordialog");
                String title = strings.getProperty("clipboard.paste.formatErrorTitle");
                JOptionPane.showMessageDialog(this, scr, title, 0);
            }
        }
        catch (Exception ex) {
            ErrorMessageHelper.showErrorDialog(this, ex);
        }
    }

    protected void updateResetButton(ColorDialogTabPanel panel) {
        ColorDialogTabPanel currentPanel = (ColorDialogTabPanel)this.tabbedPane.getSelectedComponent();
        if (currentPanel != null && currentPanel.equals(panel)) {
            this.actReset.setEnabled(panel.isColorConvertParameterModified());
        }
    }

    public PartsCategory getPartsCategory() {
        return this.partsCategory;
    }

    public boolean isSyncColorGroup(Layer layer) {
        ColorDialogTabPanel tab = this.tabs.get(layer);
        if (tab == null) {
            return false;
        }
        return tab.isSyncColorGroup();
    }

    public void setSyncColorGroup(Layer layer, boolean selected) {
        ColorDialogTabPanel tab = this.tabs.get(layer);
        if (tab != null) {
            tab.setSyncColorGroup(selected);
        }
    }

    public void setColorConvertParameters(Map<Layer, ColorConvertParameter> params) {
        if (params == null) {
            throw new IllegalArgumentException();
        }
        for (Layer layer : this.partsCategory.getLayers()) {
            ColorConvertParameter param = params.get(layer);
            if (param == null) {
                param = new ColorConvertParameter();
            }
            this.setColorConvertParameter(layer, param);
        }
    }

    public void setPartsIdentifier(PartsIdentifier partsIdentifier) {
        this.partsIdentifier = partsIdentifier;
        if (partsIdentifier == null) {
            this.setTitle(this.captionBase);
        } else {
            this.setTitle(this.captionBase + "(" + partsIdentifier.getLocalizedPartsName() + ")");
        }
    }

    public PartsIdentifier getPartsIdentifier() {
        return this.partsIdentifier;
    }

    public void setEnableLayers(Collection<Layer> layers) {
        for (Map.Entry<Layer, ColorDialogTabPanel> entry : this.tabs.entrySet()) {
            boolean enabled;
            Layer layer = entry.getKey();
            boolean bl = enabled = layers == null || layers.contains(layer);
            Integer tabIndex = this.tabbedPaneIndexMap.get(layer);
            if (tabIndex == null) continue;
            if (Main.isMacOSX()) {
                this.tabbedPane.setTitleAt(tabIndex, enabled ? layer.getLocalizedName() : "-");
            }
            this.tabbedPane.setEnabledAt(tabIndex, enabled);
            if (!logger.isLoggable(Level.FINEST)) continue;
            logger.log(Level.FINEST, "setEnableLayers(" + layer + ")=" + enabled);
        }
    }

    public boolean isApplyAll() {
        return this.chkApplyAll.isSelected();
    }

    public Map<Layer, ColorConvertParameter> getColorConvertParameters() {
        HashMap<Layer, ColorConvertParameter> params = new HashMap<Layer, ColorConvertParameter>();
        for (Layer layer : this.partsCategory.getLayers()) {
            ColorDialogTabPanel tab = this.tabs.get(layer);
            ColorConvertParameter param = tab.getColorConvertParameter();
            params.put(layer, param);
        }
        return params;
    }

    public void setColorConvertParameter(Layer layer, ColorConvertParameter param) {
        if (layer == null || param == null) {
            throw new IllegalArgumentException();
        }
        ColorDialogTabPanel tab = this.tabs.get(layer);
        if (tab == null) {
            throw new IllegalArgumentException("layer not found. " + layer + "/tabs=" + this.tabs);
        }
        tab.setColorConvertParameter(param);
    }

    public ColorConvertParameter getColorConvertParameter(Layer layer) {
        if (layer == null) {
            throw new IllegalArgumentException();
        }
        ColorDialogTabPanel tab = this.tabs.get(layer);
        if (tab == null) {
            throw new IllegalArgumentException("layer not found. " + layer);
        }
        return tab.getColorConvertParameter();
    }

    public ColorGroup getColorGroup(Layer layer) {
        if (layer == null) {
            throw new IllegalArgumentException();
        }
        ColorDialogTabPanel tab = this.tabs.get(layer);
        if (tab == null) {
            throw new IllegalArgumentException("layer not found. " + layer);
        }
        return tab.getColorGroup();
    }

    public void setColorGroup(Layer layer, ColorGroup colorGroup) {
        if (layer == null || colorGroup == null) {
            throw new IllegalArgumentException();
        }
        ColorDialogTabPanel tab = this.tabs.get(layer);
        if (tab != null) {
            tab.setColorGroup(colorGroup);
        }
    }

    public void addColorChangeListener(ColorChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        this.listeners.add(ColorChangeListener.class, listener);
    }

    public void removeColorChangeListener(ColorChangeListener listener) {
        this.listeners.remove(ColorChangeListener.class, listener);
    }

    protected void apply() {
        for (Layer layer : this.getPartsCategory().getLayers()) {
            this.fireColorChangeEvent(layer, true);
        }
    }

    protected void resetColor(ColorDialogTabPanel tab) {
        tab.resetColor();
    }

    protected void fireColorChangeEvent(Layer layer, boolean force) {
        AppConfig appConfig;
        if (layer == null) {
            throw new IllegalArgumentException();
        }
        if (!force && !(appConfig = AppConfig.getInstance()).isEnableAutoColorChange()) {
            return;
        }
        Object[] ll = this.listeners.getListenerList();
        ColorChangeEvent event = null;
        for (int i = ll.length - 2; i >= 0; i -= 2) {
            if (ll[i] != ColorChangeListener.class) continue;
            if (event == null) {
                event = new ColorChangeEvent(this, layer);
            }
            ((ColorChangeListener)ll[i + 1]).onColorChange(event);
        }
    }

    protected void fireColorGroupChangeEvent(Layer layer) {
        if (layer == null) {
            throw new IllegalArgumentException();
        }
        Object[] ll = this.listeners.getListenerList();
        ColorChangeEvent event = null;
        for (int i = ll.length - 2; i >= 0; i -= 2) {
            if (ll[i] != ColorChangeListener.class) continue;
            if (event == null) {
                event = new ColorChangeEvent(this, layer);
            }
            ((ColorChangeListener)ll[i + 1]).onColorGroupChange(event);
        }
    }

    @Override
    public String toString() {
        return "ColorDialog(partsCategory:" + this.partsCategory + ")";
    }
}

