/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.graphics.filters.ColorConvertParameter;
import charactermanaj.graphics.io.ImageResource;
import charactermanaj.graphics.io.PNGFileImageHeader;
import charactermanaj.model.Layer;
import charactermanaj.model.PartsIdentifier;
import java.util.Comparator;
import javax.swing.AbstractAction;
import javax.swing.JButton;

class InformationRowModel
implements Comparable<InformationRowModel> {
    private int order;
    private PartsIdentifier partsIdentifier;
    private Layer layer;
    private float layerOrder;
    private ImageResource imageResource;
    private JButton btnOpen;
    private PNGFileImageHeader pngHeader;
    public static final Comparator<InformationRowModel> COMPARATOR = new Comparator<InformationRowModel>(){

        @Override
        public int compare(InformationRowModel o1, InformationRowModel o2) {
            int ret = Float.compare(o1.layerOrder, o2.layerOrder);
            if (ret == 0) {
                ret = o1.layer.compareTo(o2.layer);
            }
            if (ret == 0) {
                ret = o1.order - o2.order;
            }
            if (ret == 0) {
                ret = o1.partsIdentifier.compareTo(o2.partsIdentifier);
            }
            if (ret == 0) {
                ret = o1.imageResource.compareTo(o2.imageResource);
            }
            return ret;
        }
    };

    public InformationRowModel(int order, PartsIdentifier partsIdentifier, Layer layer, float layerOrder, ImageResource imageResource, ColorConvertParameter colorConvertParameter, PNGFileImageHeader pngHeader, AbstractAction actOpen) {
        this.order = order;
        this.partsIdentifier = partsIdentifier;
        this.layer = layer;
        this.layerOrder = layerOrder;
        this.imageResource = imageResource;
        this.pngHeader = pngHeader;
        this.btnOpen = new JButton(actOpen){
            private static final long serialVersionUID = 1L;

            @Override
            public String toString() {
                return "open";
            }
        };
    }

    public int hashCode() {
        return this.partsIdentifier.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj instanceof InformationRowModel) {
            InformationRowModel o = (InformationRowModel)obj;
            return this.partsIdentifier.equals(o.partsIdentifier) && this.layer.equals(o.layer);
        }
        return false;
    }

    @Override
    public int compareTo(InformationRowModel o) {
        return COMPARATOR.compare(this, o);
    }

    public int getOrder() {
        return this.order;
    }

    public String getPartsName() {
        return this.partsIdentifier.getLocalizedPartsName();
    }

    public String getCategoryName() {
        return this.partsIdentifier.getPartsCategory().getLocalizedCategoryName();
    }

    public String getLayerName() {
        return this.layer.getLocalizedName();
    }

    public int getDefaultLayerOrder() {
        return this.layer.getOrder();
    }

    public float getLayerOrder() {
        return this.layerOrder;
    }

    public String getImageResourceName() {
        return this.imageResource.getFullName();
    }

    public JButton getButton() {
        return this.btnOpen;
    }

    public String getImageSizeStr() {
        if (this.pngHeader == null) {
            return "INVALID";
        }
        return this.pngHeader.getWidth() + "x" + this.pngHeader.getHeight();
    }

    public String getColorTypeStr() {
        if (this.pngHeader == null) {
            return "INVALID";
        }
        StringBuilder buf = new StringBuilder();
        int colorType = this.pngHeader.getColorType();
        if ((colorType & 1) != 0) {
            buf.append("Indexed ");
        }
        if ((colorType & 2) != 0) {
            buf.append("Color ");
        } else {
            buf.append("Greyscale ");
        }
        if (colorType == 6 || this.pngHeader.hasTransparencyInformation()) {
            buf.append("Alpha ");
        }
        buf.append(this.pngHeader.getBitDepth() + "bit");
        return buf.toString().trim();
    }
}

