/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.model.CustomLayerOrder;
import charactermanaj.model.CustomLayerOrderKey;
import charactermanaj.model.ListChangeListener;
import charactermanaj.model.ObservableList;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.EventListenerList;

class LayerOrderCustomizeDialogModel {
    private final EventListenerList listeners = new EventListenerList();
    private final ObservableList<CustomLayerOrderKey> patternNames = new ObservableList();
    private final Map<CustomLayerOrderKey, List<CustomLayerOrder>> patternsMap = new HashMap<CustomLayerOrderKey, List<CustomLayerOrder>>();
    private List<CustomLayerOrder> currentList = Collections.emptyList();

    public LayerOrderCustomizeDialogModel() {
        this.patternNames.addListChangeListener(new ListChangeListener<CustomLayerOrderKey>(){

            @Override
            public void onChanged(ListChangeListener.Change<? extends CustomLayerOrderKey> c) {
                switch (c.getType()) {
                    case ADD: {
                        CustomLayerOrderKey newName = c.getNewValue();
                        if (LayerOrderCustomizeDialogModel.this.patternsMap.containsKey(newName)) break;
                        LayerOrderCustomizeDialogModel.this.patternsMap.put(newName, new ArrayList());
                        LayerOrderCustomizeDialogModel.this.fireEvent(ChangeListener.ChangeType.ADD, newName);
                        break;
                    }
                    case REMOVE: {
                        CustomLayerOrderKey oldName = c.getOldValue();
                        LayerOrderCustomizeDialogModel.this.patternsMap.remove(oldName);
                        LayerOrderCustomizeDialogModel.this.fireEvent(ChangeListener.ChangeType.REMOVE, oldName);
                    }
                }
            }
        });
    }

    public void addListChangeListener(ChangeListener l) {
        this.listeners.add(ChangeListener.class, l);
    }

    public void removeListChangeListener(ChangeListener l) {
        this.listeners.remove(ChangeListener.class, l);
    }

    protected void fireEvent(ChangeListener.ChangeType type, CustomLayerOrderKey name) {
        Object[] ll = this.listeners.getListenerList();
        ChangeListener.Change event = null;
        for (int i = ll.length - 2; i >= 0; i -= 2) {
            if (ll[i] != ChangeListener.class) continue;
            if (event == null) {
                event = new ChangeListener.Change(this, name, type);
            }
            ((ChangeListener)ll[i + 1]).onChange(event);
        }
    }

    public ObservableList<CustomLayerOrder> getCurrentList() {
        return this.copyWithoutListeners(this.currentList);
    }

    public void setCurrentList(List<CustomLayerOrder> currentList) {
        if (!currentList.equals(this.currentList)) {
            this.currentList = this.copyWithoutListeners(currentList != null ? currentList : new ArrayList());
            this.fireEvent(ChangeListener.ChangeType.MODIFY, ChangeListener.ANONYMOUS);
        }
    }

    public ObservableList<CustomLayerOrderKey> getPatternNames() {
        return this.patternNames;
    }

    public ObservableList<CustomLayerOrder> getCopy(CustomLayerOrderKey name) {
        return this.copyWithoutListeners(this.patternsMap.get(name));
    }

    public void put(CustomLayerOrderKey name, List<CustomLayerOrder> layerOrderList) {
        boolean exist = this.patternsMap.containsKey(name);
        this.patternsMap.put(name, this.copyWithoutListeners(layerOrderList));
        if (!exist) {
            this.patternNames.add(name);
            this.fireEvent(ChangeListener.ChangeType.ADD, name);
        } else {
            this.fireEvent(ChangeListener.ChangeType.MODIFY, name);
        }
    }

    public void remove(CustomLayerOrderKey name) {
        if (this.patternNames.contains(name)) {
            this.patternNames.remove(name);
        }
    }

    public ObservableList<CustomLayerOrder> copyWithoutListeners(List<CustomLayerOrder> src) {
        if (src == null) {
            return null;
        }
        ObservableList<CustomLayerOrder> list = this.createObservableList();
        for (CustomLayerOrder item : src) {
            list.add(item.copy());
        }
        return list;
    }

    public ObservableList<CustomLayerOrder> createObservableList() {
        final ArrayList rawList = new ArrayList();
        final ObservableList<CustomLayerOrder> obsList = new ObservableList<CustomLayerOrder>(rawList);
        final PropertyChangeListener listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                CustomLayerOrder source = (CustomLayerOrder)evt.getSource();
                int index = rawList.indexOf(source);
                obsList.fireEvent(ListChangeListener.ChangeType.MODIFIY, index, null, source);
            }
        };
        ObservableList.Hook<CustomLayerOrder> hook = new ObservableList.Hook<CustomLayerOrder>(){

            @Override
            public void add(CustomLayerOrder item) {
                item.addPropertyChangeListener(listener);
            }

            @Override
            public void remove(CustomLayerOrder item) {
                item.removePropertyChangeListener(listener);
            }
        };
        obsList.setHook(hook);
        return obsList;
    }

    public static interface ChangeListener
    extends EventListener {
        public static final CustomLayerOrderKey ANONYMOUS = new CustomLayerOrderKey("", "", null);

        public void onChange(Change var1);

        public static class Change
        extends EventObject {
            private static final long serialVersionUID = -4578290841626577210L;
            private CustomLayerOrderKey name;
            private ChangeType changeType;

            public Change(LayerOrderCustomizeDialogModel source, CustomLayerOrderKey name, ChangeType changeType) {
                super(source);
                this.name = name;
                this.changeType = changeType;
            }

            public CustomLayerOrderKey getName() {
                return this.name;
            }

            public ChangeType getChangeType() {
                return this.changeType;
            }

            @Override
            public LayerOrderCustomizeDialogModel getSource() {
                return (LayerOrderCustomizeDialogModel)super.getSource();
            }

            @Override
            public String toString() {
                return "Change [name=" + this.name + ", changeType=" + (Object)((Object)this.changeType) + "]";
            }
        }

        public static enum ChangeType {
            ADD,
            MODIFY,
            REMOVE;

        }
    }
}

