/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.Main;
import charactermanaj.graphics.filters.BackgroundColorFilter;
import charactermanaj.model.AppConfig;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import charactermanaj.util.UIHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;
import java.util.concurrent.Semaphore;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicComboBoxEditor;

class PreviewControlPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(PreviewControlPanel.class.getName());
    protected static final String STRINGS_RESOURCE = "languages/previewpanel";
    private JCheckBox chkPinning;
    private JCheckBox chkNoAlpha;
    private JCheckBox chkGrayscale;
    private JSlider zoomSlider;
    private JComboBox zoomCombo;
    private static final int MIN_INDEX = -170;
    private static final int MAX_INDEX = 219;
    private double minimumZoomFactor;
    private double maximumZoomFactor;
    private int currentZoomFactorInt;
    private BackgroundColorFilter.BackgroundColorMode backgroundColorMode;
    private Semaphore changeChkLock = new Semaphore(1);

    private static double logN(double a, double x) {
        return Math.log(x) / Math.log(a);
    }

    private static int zoomFactorToIndex(double zoomFactor) {
        return (int)Math.round(PreviewControlPanel.logN(1.1, zoomFactor) * 10.0);
    }

    private static double zoomFactorFromIndex(int index) {
        return Math.pow(1.1, (double)index / 10.0);
    }

    public PreviewControlPanel() {
        Properties strings = LocalizedResourcePropertyLoader.getCachedInstance().getLocalizedProperties(STRINGS_RESOURCE);
        UIHelper uiHelper = UIHelper.getInstance();
        Icon pinIcon = uiHelper.createTwoStateIcon("icons/pin-icon1.png", "icons/pin-icon2.png");
        this.chkPinning = new JCheckBox(pinIcon);
        this.chkPinning.setToolTipText(strings.getProperty("tooltip.zoompanel.pinning"));
        Icon stateIcon = new Icon(){

            @Override
            public int getIconHeight() {
                return 12;
            }

            @Override
            public int getIconWidth() {
                return 6;
            }

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                boolean sw = false;
                if (c instanceof AbstractButton) {
                    AbstractButton btn = (AbstractButton)c;
                    sw = btn.isSelected();
                }
                int w = this.getIconWidth();
                int h = this.getIconHeight();
                int s = Math.min(w, h);
                int ox = 0;
                int oy = 0;
                if (w > s) {
                    ox = (w - s) / 2;
                }
                if (h > s) {
                    oy = (h - s) / 2;
                }
                if (sw) {
                    AppConfig appConfig = AppConfig.getInstance();
                    Color fillColor = appConfig.getSelectedItemBgColor();
                    g.setColor(fillColor);
                    g.fillOval(x + ox, y + oy, s, w);
                }
                g.setColor(Color.GRAY);
                g.drawOval(x + ox, y + oy, s, s);
            }
        };
        this.chkNoAlpha = new JCheckBox(stateIcon);
        this.chkGrayscale = new JCheckBox(stateIcon);
        this.chkNoAlpha.setToolTipText(strings.getProperty("tooltip.zoompanel.checkalpha"));
        this.chkGrayscale.setToolTipText(strings.getProperty("tooltip.zoompanel.checkgrayscale"));
        this.backgroundColorMode = BackgroundColorFilter.BackgroundColorMode.ALPHABREND;
        ChangeListener chkAlphaGrayChangeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PreviewControlPanel.this.onChangeCheckAlphaGray();
            }
        };
        this.chkNoAlpha.addChangeListener(chkAlphaGrayChangeListener);
        this.chkGrayscale.addChangeListener(chkAlphaGrayChangeListener);
        this.zoomSlider = new JSlider(0, -170, 219, 0);
        this.zoomSlider.setToolTipText(strings.getProperty("tooltip.zoompanel.zoomfactor_slider"));
        this.zoomCombo = new JComboBox();
        this.zoomCombo.setToolTipText(strings.getProperty("tooltip.zoompanel.zoomfactor_combo"));
        this.minimumZoomFactor = PreviewControlPanel.zoomFactorFromIndex(this.zoomSlider.getMinimum());
        this.maximumZoomFactor = PreviewControlPanel.zoomFactorFromIndex(this.zoomSlider.getMaximum());
        int minZoomRange = (int)Math.round(this.minimumZoomFactor * 100.0);
        int maxZoomRange = (int)Math.round(this.maximumZoomFactor * 100.0);
        List<Integer> predefinedZoomRanges = this.getPredefinedZoomRanges();
        for (int zoomRange : predefinedZoomRanges) {
            if (zoomRange < minZoomRange) {
                minZoomRange = zoomRange;
            }
            if (zoomRange > maxZoomRange) {
                maxZoomRange = zoomRange;
            }
            this.zoomCombo.addItem(Integer.toString(zoomRange));
        }
        final int[] zoomRanges = new int[]{minZoomRange, maxZoomRange};
        this.currentZoomFactorInt = 100;
        this.zoomCombo.setSelectedItem(Integer.toString(this.currentZoomFactorInt));
        this.zoomCombo.setEditable(true);
        if (!Main.isMacOSX()) {
            this.zoomCombo.setEditor(new BasicComboBoxEditor(){
                {
                    this.editor = new JTextField(3){
                        private static final long serialVersionUID = 1L;

                        @Override
                        public void setBorder(Border border) {
                        }

                        @Override
                        public void setText(String s) {
                            if (this.getText().equals(s)) {
                                return;
                            }
                            super.setText(s);
                        }
                    };
                }
            });
        }
        final Semaphore changeLock = new Semaphore(1);
        this.zoomCombo.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                int zoomFactorInt;
                boolean adjusted = false;
                String value = (String)PreviewControlPanel.this.zoomCombo.getSelectedItem();
                try {
                    zoomFactorInt = Integer.parseInt(value);
                    if (zoomFactorInt < zoomRanges[0]) {
                        zoomFactorInt = zoomRanges[0];
                        adjusted = true;
                    } else if (zoomFactorInt > zoomRanges[1]) {
                        zoomFactorInt = zoomRanges[1];
                        adjusted = true;
                    }
                }
                catch (RuntimeException ex) {
                    zoomFactorInt = 100;
                    adjusted = true;
                }
                if (adjusted) {
                    PreviewControlPanel.this.zoomCombo.setSelectedItem(Integer.toString(zoomFactorInt));
                    Toolkit tk = Toolkit.getDefaultToolkit();
                    tk.beep();
                }
                if (changeLock.tryAcquire()) {
                    try {
                        PreviewControlPanel.this.zoomSlider.setValue(PreviewControlPanel.zoomFactorToIndex((double)zoomFactorInt / 100.0));
                    }
                    finally {
                        changeLock.release();
                    }
                }
                PreviewControlPanel.this.fireZoomFactorChange(zoomFactorInt);
            }
        });
        this.zoomSlider.addChangeListener(new ChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stateChanged(ChangeEvent e) {
                int index = PreviewControlPanel.this.zoomSlider.getValue();
                double zoomFactor = PreviewControlPanel.zoomFactorFromIndex(index);
                int zoomFactorInt = (int)Math.round(zoomFactor * 100.0);
                if (changeLock.tryAcquire()) {
                    try {
                        PreviewControlPanel.this.zoomCombo.setSelectedItem(Integer.toString(zoomFactorInt));
                    }
                    finally {
                        changeLock.release();
                    }
                    PreviewControlPanel.this.fireZoomFactorChange(zoomFactorInt);
                }
            }
        });
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.ipadx = 0;
        gbc.ipady = 0;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.anchor = 10;
        gbc.insets = new Insets(0, 0, 0, 5);
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        this.add((Component)this.chkPinning, gbc);
        gbc.gridx = 1;
        gbc.weightx = 0.0;
        gbc.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.chkGrayscale, gbc);
        gbc.gridx = 2;
        gbc.weightx = 0.0;
        gbc.insets = new Insets(0, 0, 0, 5);
        this.add((Component)this.chkNoAlpha, gbc);
        gbc.gridx = 3;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        this.add((Component)this.zoomSlider, gbc);
        gbc.gridx = 4;
        gbc.weightx = 0.0;
        gbc.insets = new Insets(3, 0, 3, 0);
        gbc.fill = 3;
        this.add((Component)this.zoomCombo, gbc);
        Integer scrollbarWidth = (Integer)UIManager.get("ScrollBar.width");
        logger.log(Level.CONFIG, "ScrollBar.width=" + scrollbarWidth);
        if (scrollbarWidth == null) {
            scrollbarWidth = Integer.parseInt(strings.getProperty("uiconstraint.scrollbar.width"));
        }
        gbc.gridx = 5;
        gbc.weightx = 0.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 0, 0, scrollbarWidth);
        this.add((Component)new JLabel("%"), gbc);
    }

    protected List<Integer> getPredefinedZoomRanges() {
        AppConfig appConfig = AppConfig.getInstance();
        String strs = appConfig.getPredefinedZoomRanges();
        TreeSet<Integer> ranges = new TreeSet<Integer>();
        for (String str : strs.split(",")) {
            if ((str = str.trim()).length() <= 0) continue;
            try {
                int zoomFactor = Integer.parseInt(str);
                ranges.add(zoomFactor);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        ranges.add(100);
        return new ArrayList<Integer>(ranges);
    }

    protected void fireZoomFactorChange(int newZoomFactor) {
        if (this.currentZoomFactorInt != newZoomFactor) {
            int oldValue = this.currentZoomFactorInt;
            this.currentZoomFactorInt = newZoomFactor;
            this.firePropertyChange("zoomFactorInt", oldValue, newZoomFactor);
        }
    }

    protected void onChangeCheckAlphaGray() {
        this.changeChkLock.tryAcquire();
        try {
            BackgroundColorFilter.BackgroundColorMode backgroundColorMode = BackgroundColorFilter.BackgroundColorMode.valueOf(this.chkNoAlpha.isSelected(), this.chkGrayscale.isSelected());
            this.setBackgroundColorMode(backgroundColorMode);
        }
        finally {
            this.changeChkLock.release();
        }
    }

    public BackgroundColorFilter.BackgroundColorMode getBackgroundColorMode() {
        return this.backgroundColorMode;
    }

    public void setBackgroundColorMode(BackgroundColorFilter.BackgroundColorMode backgroundColorMode) {
        if (backgroundColorMode == null) {
            throw new IllegalArgumentException();
        }
        BackgroundColorFilter.BackgroundColorMode oldcm = this.backgroundColorMode;
        if (oldcm != backgroundColorMode) {
            this.backgroundColorMode = backgroundColorMode;
            this.changeChkLock.tryAcquire();
            try {
                this.chkNoAlpha.setSelected(backgroundColorMode.isNoAlphaChannel());
                this.chkGrayscale.setSelected(backgroundColorMode.isGrayscale());
            }
            finally {
                this.changeChkLock.release();
            }
            this.firePropertyChange("backgroundColorMode", (Object)oldcm, (Object)backgroundColorMode);
        }
    }

    public boolean isPinned() {
        return this.chkPinning.isSelected();
    }

    public void setPinned(boolean pinned) {
        this.chkPinning.setSelected(pinned);
        if (this.isDisplayable()) {
            this.setVisible(pinned);
        }
    }

    public double getZoomFactor() {
        return (double)this.currentZoomFactorInt / 100.0;
    }

    public void setZoomFactor(double zoomFactor) {
        int zoomFactorInt;
        if (zoomFactor < this.minimumZoomFactor) {
            zoomFactor = this.minimumZoomFactor;
        }
        if (zoomFactor > this.maximumZoomFactor) {
            zoomFactor = this.maximumZoomFactor;
        }
        if ((zoomFactorInt = (int)Math.round(zoomFactor * 100.0)) != this.currentZoomFactorInt) {
            this.zoomCombo.setSelectedItem(Integer.toString(zoomFactorInt));
        }
    }
}

