<?php
/**
* ʸ󥳡ǥѴ饹
*
* PHP version 5
*
* @package    core
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/

class charcoal_EncodingConverter
{
	//==========================================
	//	Converter Types
	//==========================================
	const NO_CONVERT		= 0;
	const PHP_TO_DB  		= 1;
	const PHP_TO_HTML  		= 2;
	const PHP_TO_LOG  		= 3;
	const HTML_TO_PHP  		= 4;
	const DB_TO_PHP  		= 5;
	const DB_TO_HTML  		= 6;
	const DB_TO_LOG	  		= 7;
	const HTML_TO_DB  		= 8;
	const PHP_TO_MAIL		= 9;

	var $_type;
	var $_from;
	var $_to;

	/*
	 *	󥹥ȥ饯
	 */
	private function __construct( $type )
	{
		$this->_type = $type;
		$this->setEncodingSettings();
	}

	/*
	 *	ʸ󤫤饳С
	 */
	public static function fromString( $str )
	{
		switch( $str ){
		case 'NO_CONVERT':		return new charcoal_EncodingConverter( charcoal_EncodingConverter::NO_CONVERT );	break;
		case 'PHP_TO_DB':		return new charcoal_EncodingConverter( charcoal_EncodingConverter::PHP_TO_DB );		break;
		case 'PHP_TO_HTML':		return new charcoal_EncodingConverter( charcoal_EncodingConverter::PHP_TO_HTML );	break;
		case 'PHP_TO_LOG':		return new charcoal_EncodingConverter( charcoal_EncodingConverter::PHP_TO_LOG );	break;
		case 'HTML_TO_PHP':		return new charcoal_EncodingConverter( charcoal_EncodingConverter::HTML_TO_PHP );	break;
		case 'DB_TO_PHP':		return new charcoal_EncodingConverter( charcoal_EncodingConverter::DB_TO_PHP );		break;
		case 'DB_TO_HTML':		return new charcoal_EncodingConverter( charcoal_EncodingConverter::DB_TO_HTML );	break;
		case 'DB_TO_LOG':		return new charcoal_EncodingConverter( charcoal_EncodingConverter::DB_TO_LOG );		break;
		case 'HTML_TO_DB':		return new charcoal_EncodingConverter( charcoal_EncodingConverter::HTML_TO_DB );	break;
		case 'PHP_TO_MAIL':		return new charcoal_EncodingConverter( charcoal_EncodingConverter::PHP_TO_MAIL );	break;
		}

		throw new charcoal_EncodingConverterException( "Illegal fromString() parameter: $str" );
	}

	/*
	 *	Ѵ
	 */
	public function convertEncoding( $str )
	{
		if ( $this->_type == charcoal_EncodingConverter::NO_CONVERT ){
			return $str;
		}
//print "EncodingConvert:" . $this->_from . "-->" . $this->_to . " message:" . $str . "<BR>";
//print "EncodingConvert:" . $this->_type . " message:" . $str . "<BR>";

		return mb_convert_encoding( $str, $this->_to, $this->_from );
	}

	/*
	 *	Ѵ
	 */
	public function convertEncodingArray( $ary )
	{
		if ( $ary == NULL ){
			throw new charcoal_NullPointerException( $ary );
		}
		if ( !is_array($ary) ){
			throw new charcoal_ParameterException( "ary", gettype($ary), "must be an array" );
		}

		$new_array = array();

		foreach( $ary as $value ){
			$new_value = mb_convert_encoding( $value, $this->_to, $this->_from );
//print "convertEncodingArray:" . $value . " => " . $new_value . "<BR>";
			$new_array[] = $new_value;
		}

		return $new_array;
	}

	/*
	 *	ʸƵŪѴ
	 */
	public function convertEncodingRecursive( $data )
	{
		if ( $data == NULL ){
			throw new charcoal_NullPointerException( $ary );
		}
		if ( is_array($data) ){
			foreach( $data as $key => $value ){
				if ( $value ){
					$value = $this->convertEncodingRecursive( $value );
					$data[$key] = $value;
				}
			}
		}
		else if ( is_string($data) ){
			$data = $this->convertEncoding( $data );
		}

		return $data;
	}

	/*
	 *	Ѵפ
	 */
	public function getType()
	{
		return $this->_type;
	}

	/*
	 *	Ѵʸɤ
	 */
	public function getFromEncoding()
	{
		return $this->_from;
	}

	/*
	 *	Ѵʸɤ
	 */
	public function getToEncoding()
	{
		return $this->_to;
	}

	/*
	 *	ʸѴ
	 */
	public function __toString()
	{
		return "[EncodingConverter]" . $this->_from . " => " . $this->_to;
	}

	/*
	 *	ѴѴʸɤȽ
	 */
	private function setEncodingSettings()
	{
		// Ѵ
		switch( $this->_type ){
		case charcoal_EncodingConverter::PHP_TO_DB:
		case charcoal_EncodingConverter::PHP_TO_HTML:
		case charcoal_EncodingConverter::PHP_TO_LOG:
		case charcoal_EncodingConverter::PHP_TO_MAIL:
			$this->_from = charcoal_Profile::getString('PHP_CODE');
			break;

		case charcoal_EncodingConverter::HTML_TO_PHP:
		case charcoal_EncodingConverter::HTML_TO_DB:
			$this->_from = charcoal_Profile::getString('HTML_CODE');
			break;

		case charcoal_EncodingConverter::DB_TO_PHP:
		case charcoal_EncodingConverter::DB_TO_HTML:
		case charcoal_EncodingConverter::DB_TO_LOG:
			$this->_from = charcoal_Profile::getString('DB_CODE');
			break;
		}

		// Ѵ
		switch( $this->_type ){
		case charcoal_EncodingConverter::PHP_TO_LOG:
		case charcoal_EncodingConverter::DB_TO_LOG:
			$this->_to = charcoal_Profile::getString('LOG_CODE');
			break;

		case charcoal_EncodingConverter::HTML_TO_PHP:
		case charcoal_EncodingConverter::DB_TO_PHP:
			$this->_to = charcoal_Profile::getString('PHP_CODE');
			break;

		case charcoal_EncodingConverter::DB_TO_HTML:
		case charcoal_EncodingConverter::PHP_TO_HTML:
			$this->_to = charcoal_Profile::getString('HTML_CODE');
			break;

		case charcoal_EncodingConverter::PHP_TO_DB:
		case charcoal_EncodingConverter::HTML_TO_DB:
			$this->_to = charcoal_Profile::getString('DB_CODE');
			break;

		case charcoal_EncodingConverter::PHP_TO_MAIL:
			$this->_to = "ISO-2022-JP";
			break;

		}
	}
}
