<?php
/**
* ե졼ѥ饹
*
* PHP version 5
*
* @package    core
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/

class charcoal_FrameworkClassLoader
{
	static $class_paths;

	/*
	 * 饹ѥν
	 */
	public static function initClassPath()
	{
		if ( self::$class_paths ){
			return self::$class_paths;
		}

		self::$class_paths = array(

		// core classes
				'charcoal_Annotation'				=> 'core/Annotation.class.php',
				'charcoal_AnnotationUtil'			=> 'core/AnnotationUtil.class.php',
				'charcoal_Benchmark'				=> 'core/Benchmark.class.php',
				'charcoal_CacheFile'				=> 'core/CacheFile.class.php',
				'charcoal_CacheFileHeader'			=> 'core/CacheFileHeader.class.php',
				'charcoal_CacheFileFactory'			=> 'core/CacheFileFactory.class.php',
				'charcoal_ClassLoaderFactory'		=> 'core/ClassLoaderFactory.class.php',
				'charcoal_ClassUtil'				=> 'core/ClassUtil.class.php',
				'charcoal_Config'					=> 'core/Config.class.php',
				'charcoal_ConfigProviderFactory'	=> 'core/ConfigProviderFactory.class.php',
				'charcoal_ConfigLoader'				=> 'core/ConfigLoader.class.php',
				'charcoal_ConfigUtil'				=> 'core/ConfigUtil.class.php',
				'charcoal_DataSourceFactory'		=> 'core/DataSourceFactory.class.php',
				'charcoal_DTO'						=> 'core/DTO.class.php',
				'charcoal_DB'						=> 'core/DB.class.php',
				'charcoal_DIContainer'				=> 'core/DIContainer.class.php',
				'charcoal_DispatcherFactory'		=> 'core/DispatcherFactory.class.php',
				'charcoal_EncodingConverter'		=> 'core/EncodingConverter.class.php',
				'charcoal_FilterFactory'			=> 'core/FilterFactory.class.php',
				'charcoal_FormFactory'				=> 'core/FormFactory.class.php',
				'charcoal_Framework'				=> 'core/Framework.class.php',
				'charcoal_Logger'					=> 'core/Logger.class.php',
				'charcoal_LoggerFactory'			=> 'core/LoggerFactory.class.php',
				'charcoal_ModuleFactory'			=> 'core/ModuleFactory.class.php',
				'charcoal_ModuleGraph'				=> 'core/ModuleGraph.class.php',
				'charcoal_ModuleGraphNode'			=> 'core/ModuleGraphNode.class.php',
				'charcoal_ProcedureFactory'			=> 'core/ProcedureFactory.class.php',
				'charcoal_ProcedureContext'			=> 'core/ProcedureContext.class.php',
				'charcoal_Profile'					=> 'core/Profile.class.php',
				'charcoal_RendererFactory'			=> 'core/RendererFactory.class.php',
				'charcoal_ResourceCache'			=> 'core/ResourceCache.class.php',
				'charcoal_ResourceFactory'			=> 'core/ResourceFactory.class.php',
				'charcoal_ResourceLocator'			=> 'core/ResourceLocator.class.php',
				'charcoal_Request'					=> 'core/Request.class.php',
				'charcoal_Response'					=> 'core/Response.class.php',
				'charcoal_Session'					=> 'core/Session.class.php',
				'charcoal_SessionHandlerFactory'	=> 'core/SessionHandlerFactory.class.php',
				'charcoal_SQLBuilderFactory'		=> 'core/SQLBuilderFactory.class.php',
				'charcoal_SQLCriteria'				=> 'core/SQLCriteria.class.php',
				'charcoal_System'					=> 'core/System.class.php',
				'charcoal_TextHTMLRenderer'			=> 'core/TextHTMLRenderer.class.php',
				'charcoal_TransformerFactory'		=> 'core/TransformerFactory.class.php',
				'charcoal_URL'						=> 'core/URL.class.php',
				'charcoal_URLMapperFactory'			=> 'core/URLMapperFactory.class.php',
				'charcoal_ValidatorFactory'			=> 'core/ValidatorFactory.class.php',

		// interface classes
				'charcoal_IComponent'				=> 'interfaces/IComponent.class.php',
				'charcoal_IClassLoader'				=> 'interfaces/IClassLoader.class.php',
				'charcoal_IConfigProvider'			=> 'interfaces/IConfigProvider.class.php',
				'charcoal_IDataSource'				=> 'interfaces/IDataSource.class.php',
				'charcoal_IDispatcher'				=> 'interfaces/IDispatcher.class.php',
				'charcoal_IFilter'					=> 'interfaces/IFilter.class.php',
				'charcoal_IForm'					=> 'interfaces/IForm.class.php',
				'charcoal_IFormModel'				=> 'interfaces/IFormModel.class.php',
				'charcoal_ILogger'					=> 'interfaces/ILogger.class.php',
				'charcoal_IModel'					=> 'interfaces/IModel.class.php',
				'charcoal_IModule'					=> 'interfaces/IModule.class.php',
				'charcoal_IProcedure'				=> 'interfaces/IProcedure.class.php',
				'charcoal_IRenderer'				=> 'interfaces/IRenderer.class.php',
				'charcoal_IResource'				=> 'interfaces/IResource.class.php',
				'charcoal_ISessionHandler'			=> 'interfaces/ISessionHandler.class.php',
				'charcoal_ISQLBuilder'				=> 'interfaces/ISQLBuilder.class.php',
				'charcoal_ITableModel'				=> 'interfaces/ITableModel.class.php',
				'charcoal_ITransformer'				=> 'interfaces/ITransformer.class.php',
				'charcoal_IValidator'				=> 'interfaces/IValidator.class.php',
				'charcoal_IURLMapper'				=> 'interfaces/IURLMapper.class.php',

		// HTML objects
				'charcoal_HTMLChoiceGroupObject'	=> 'html_objects/HTMLChoiceGroupObject.class.php',
				'charcoal_HTMLContainerObject'		=> 'html_objects/HTMLContainerObject.class.php',
				'charcoal_HTMLFormFactory'			=> 'html_objects/HTMLFormFactory.class.php',
				'charcoal_HTMLFormObject'			=> 'html_objects/HTMLFormObject.class.php',
				'charcoal_HTMLInputObject'			=> 'html_objects/HTMLInputObject.class.php',
				'charcoal_HTMLLeafObject'			=> 'html_objects/HTMLLeafObject.class.php',
				'charcoal_HTMLListObject'			=> 'html_objects/HTMLListObject.class.php',
				'charcoal_HTMLObject'				=> 'html_objects/HTMLObject.class.php',
				'charcoal_HTMLPanelObject'			=> 'html_objects/HTMLPanelObject.class.php',
				'charcoal_HTMLSelectObject'			=> 'html_objects/HTMLSelectObject.class.php',
				'charcoal_HTMLTextObject'			=> 'html_objects/HTMLTextObject.class.php',
				'charcoal_HTMLTextAreaObject'		=> 'html_objects/HTMLTextAreaObject.class.php',

		// logger classes
				'charcoal_FileLogger'				=> 'loggers/FileLogger.class.php',
				'charcoal_ScreenLogger'				=> 'loggers/ScreenLogger.class.php',

		// constant classes
				'charcoal_ComponentScope'			=> 'constants/ComponentScope.class.php',

		// exception classes
				'charcoal_AnnotaionException'				=> 'exceptions/AnnotaionException.class.php',
				'charcoal_ArrayFormatException'				=> 'exceptions/ArrayFormatException.class.php',
				'charcoal_BooleanFormatException'			=> 'exceptions/BooleanFormatException.class.php',
				'charcoal_ClassLoaderConfigException'		=> 'exceptions/ClassLoaderConfigException.class.php',
				'charcoal_ClassNotFoundException'			=> 'exceptions/ClassNotFoundException.class.php',
				'charcoal_ComponentConfigException'			=> 'exceptions/ComponentConfigException.class.php',
				'charcoal_ComponentNotRegisteredException'	=> 'exceptions/ComponentNotRegisteredException.class.php',
				'charcoal_ConfigFileNotFoundException'		=> 'exceptions/ConfigFileNotFoundException.class.php',
				'charcoal_DBException'						=> 'exceptions/DBException.class.php',
				'charcoal_EncodingConverterException'		=> 'exceptions/EncodingConverterException.class.php',
				'charcoal_Exception'						=> 'exceptions/Exception.class.php',
				'charcoal_HttpException'					=> 'exceptions/HttpException.class.php',
				'charcoal_InterfaceImplementException'		=> 'exceptions/InterfaceImplementException.class.php',
				'charcoal_IntegerFormatException'			=> 'exceptions/IntegerFormatException.class.php',
				'charcoal_LoggerConfigException'			=> 'exceptions/LoggerConfigException.class.php',
				'charcoal_ModuleGraphConfigException'		=> 'exceptions/ModuleGraphConfigException.class.php',
				'charcoal_ModuleGraphTransitionException'	=> 'exceptions/ModuleGraphTransitionException.class.php',
				'charcoal_ModuleGraphNodeException'			=> 'exceptions/ModuleGraphNodeException.class.php',
				'charcoal_NonObjectException'				=> 'exceptions/NonObjectException.class.php',
				'charcoal_NullPointerException'				=> 'exceptions/NullPointerException.class.php',
				'charcoal_ParameterException'				=> 'exceptions/ParameterException.class.php',
				'charcoal_ProcedureConfigException'			=> 'exceptions/ProcedureConfigException.class.php',
				'charcoal_ProfileException'					=> 'exceptions/ProfileException.class.php',
				'charcoal_RendererException'				=> 'exceptions/RendererException.class.php',
				'charcoal_StringFormatException'			=> 'exceptions/StringFormatException.class.php',
				'charcoal_TableModelException'				=> 'exceptions/TableModelException.class.php',
				'charcoal_TemplateFileNotFoundException'	=> 'exceptions/TemplateFileNotFoundException.class.php',
				'charcoal_URLMapperConfigException'			=> 'exceptions/URLMapperConfigException.class.php',



		// config provider classes
				'charcoal_SpycConfigProvider'				=> 'config_providers/SpycConfigProvider.class.php',
				'charcoal_CachedSpycConfigProvider'			=> 'config_providers/CachedSpycConfigProvider.class.php',

		// dispatcher classes
				'charcoal_SimpleDispatcher'					=> 'dispatchers/SimpleDispatcher.class.php',

		// table model classes
				'charcoal_DefaultTableModel'				=> 'table_models/DefaultTableModel.class.php',

		// form model classes
				'charcoal_DefaultFormModel'					=> 'form_models/DefaultFormModel.class.php',

		// data source classes
				'charcoal_PearDbDataSource'					=> 'data_sources/PearDbDataSource.class.php',

		// session hanlder classes
				'charcoal_DefaultSessionHandler'			=> 'session_handlers/DefaultSessionHandler.class.php',

		// SQL Builder classes
				'charcoal_DefaultSQLBuilder'				=> 'sql_builders/DefaultSQLBuilder.class.php',
				'charcoal_MySQL_SQLBuilder'					=> 'sql_builders/MySQL_SQLBuilder.class.php',
				'charcoal_PostgreSQL_SQLBuilder'			=> 'sql_builders/PostgreSQL_SQLBuilder.class.php',

		// form classes
				'charcoal_SimpleForm'						=> 'forms/SimpleForm.class.php',

		// procedure classes
				'charcoal_DefaultProcedure'					=> 'procedures/DefaultProcedure.class.php',
				'charcoal_ModuleGraphProcedure'				=> 'procedures/ModuleGraphProcedure.class.php',

		// renderer classes
				'charcoal_SmartyRenderer'					=> 'renderers/SmartyRenderer.class.php',
				'charcoal_PHPTALRenderer'					=> 'renderers/PHPTALRenderer.class.php',

		// filter classes
				'charcoal_FormOutputFilter'					=> 'filters/FormOutputFilter.class.php',
				'charcoal_FormReadOnlyOutputFilter'			=> 'filters/FormReadOnlyOutputFilter.class.php',
				'charcoal_EncodingInputFilter'				=> 'filters/EncodingInputFilter.class.php',
				'charcoal_EncodingOutputFilter'				=> 'filters/EncodingOutputFilter.class.php',
				'charcoal_CharcoalPagerOutputFilter'		=> 'filters/CharcoalPagerOutputFilter.class.php',

		// component classes
				'charcoal_Linker'							=> 'components/charcoal/Linker.class.php',
				'charcoal_BreadcrumbList'					=> 'components/charcoal/BreadcrumbList.class.php',
				'CharcoalPager'								=> 'components/charcoal/CharcoalPager.class.php',
				'charcoal_Calendar'							=> 'components/charcoal/Calendar.class.php',
				'charcoal_CharcoalMail'						=> 'components/mail/CharcoalMail.class.php',

		// transformer classes
				'charcoal_SimpleTransformer'				=> 'transformers/SimpleTransformer.class.php',

		// URL Mapper classes
				'charcoal_SimpleURLMapper'					=> 'url_mappers/SimpleURLMapper.class.php',

		);

		return self::$class_paths;
	}

	/*
	 * 饹
	 */
	public static function loadClass( $class_name )
	{
		// 饹ѥν
		$class_paths = self::initClassPath();

		// ե졼Υ饹ǤϤʤFALSEֵ
		if ( !isset($class_paths[ $class_name ]) ){
			return FALSE;
		}

		// 饹̾饯饹ѥ
		$classPath = $class_paths[ $class_name ];

		// ɤ߹
		require_once( 'classes/' . $classPath );

		// ˥饹ɤ߹ޤ줿å
		if ( !class_exists( $class_name ) && !interface_exists( $class_name ) ){
			require_once( 'exceptions/ClassNotFoundException.class.php' );
			throw new charcoal_ClassNotFoundException( $class_name, $classPath );
		}

		return TRUE;
	}
}
