<?php
/**
* SQLӥ륤󥿥ե
*
* PHP version 5
*
* @package    interfaces
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/

interface charcoal_ISQLBuilder
{

	/*
	 * SQLӥ̾
	 */
	public function getSQLBuilderName();

	/**
	 *  SQLӥ
	 */
	public function init( charcoal_Config $config );

	/*
	 *	SQL(SELECT)
	 */
	public  function buildSelectSQL( charcoal_ITableModel $model, charcoal_SQLCriteria $criteria = NULL );

	/*
	 *	SQL(UPDATE)
	 */
	public  function buildUpdateSQL( charcoal_ITableModel $model, charcoal_DTO $dto );

	/*
	 *	SQL(INSERT)
	 */
	public  function buildInsertSQL( charcoal_ITableModel $model, charcoal_DTO $dto );

	/*
	 *	SQL(count)
	 */
	public  function buildCountSQL( charcoal_ITableModel $model, charcoal_SQLCriteria $criteria = NULL );

	/*
	 *	SQL(max)
	 */
	public  function buildMaxSQL( charcoal_ITableModel $model, $field_name, charcoal_SQLCriteria $criteria = NULL );

	/*
	 *	SQL(DELETE)
	 */
	public  function buildDeleteSQL( charcoal_ITableModel $model, charcoal_SQLCriteria $criteria = NULL );

	/*
	 *	SQL(LAST_INSERT_ID)
	 */
	public  function buildLastIdSQL();

	/*
	 *	SQL(CREATE DATABASE)
	 */
	public  function buildCreateDatabaseSQL( $db_name, $charset = NULL );

	/*
	 *	SQL(CREATE TABLE)
	 */
	public  function buildCreateTableSQL( charcoal_ITableModel $model );
}
