<?
/**
* PHPTAL
*
* PHP version 5
*
* @package    renderers
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/
require_once 'PHPTAL.php';

class charcoal_PHPTALRenderer implements charcoal_IRenderer
{
	var $_template_files;
	var $_repository;

	/*
	 *	󥹥ȥ饯
	 */
	public function __construct()
	{
		$this->_template_files = array();
		$this->_repository = NULL;
	}

	/*
	 * 顼̾
	 */
	public function getRendererName()
	{
		return "Smarty Renderer";
	}

	/*
	 * 顼
	 */
	public function init( charcoal_Config $config )
	{
		// ƥץ졼ȥեޥåԥ
		$this->_template_files	= $config->getArray( 'template_files' );

		// ݥȥ
		$this->_repository = $config->getString( 'repository', TRUE );
	}

	/*
	 * ƥץ졼ȥե̾
	 */
	private function getTemplateFile( $template_name )
	{
		$template_file = $this->_template_files[ $template_name ];
		if ( !$template_file ){
			throw new charcoal_TemplateFileNotFoundException( $template_name );
		}
		return $template_file;
	}

	/*
	 * 󥰤Ԥ
	 */
	public function render( $proc_key, charcoal_ProcedureContext $context, charcoal_Response $response )
	{
		log_info( "system",  "PhpTalRendererˤ󥰤Ԥޤ", __FILE__, __LINE__ );

		try{

			// ƥץ졼̾
			$template_name = $context->get( 'phptal_template' );

			// ƥץ졼ȥե̾Ѵ
			$template_file = $this->getTemplateFile( $template_name );

			// PHPTAL֥Ȥ
			$template = new PHPTAL( $template_file );

			// 쥹ݥ󥹥ǡ򤹤٤assign
			$keys = $response->getKeys();
			foreach( $keys as $key ){
				$value = $response->get( $key );
				$template->$key = $value;
			}

			// ƥץ졼ȥѥ
			$template->setTemplateRepository( $this->_repository );

			// 
			echo $template->execute();

		}
		catch ( Exception $e ){
			throw new charcoal_RendererException( $proc_key, "rendering failed", $e );
		}

		log_info( "system",  "PhpTalRendererˤ󥰤Ԥޤ", __FILE__, __LINE__ );
	}
}
?>