<?php
/**
* ͤݻ륯饹
*
* PHP version 5
*
* @package    core
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/

class Config
{
	private $_config;

	/*
	 *    󥹥ȥ饯
	 */
	public function __construct( $data = NULL )
	{
		$this->_config = $data ? $data : array();
	}

	/*
	 *
	 */
	public function isEmptry()
	{
		return (count($this->_config) == 0);
	}

	/*
	 *¸ߤ뤫
	 */
	public function keyExists( $key )
	{
		return isset($this->_config[ $key ]);
	}

	/*
	 *ɲ
	 */
	public function append( $add )
	{
		if ( $add ){
			if ( is_array( $add ) ){
				$this->_config = array_merge( $this->_config, $add );
			}
			else{
				$this->_config[] = $add;
			}
		}
	}

	/*
	 *쳬ؤΥ
	 */
	public function getKeys()
	{
		return array_keys( $this->_config );
	}

	/*
	 * ͤʸȤƼ
	 */
	public function getString( $key, $process_macro = NULL )
	{
		// ̤ʤʸ֤
		if ( !isset($this->_config[ $key ]) ){
			return s('');
		}

		// ͤ
		$value = $this->_config[ $key ];

		// եޥåȳǧ
		if ( !is_string($value) ){
			throw new StringFormatException( $value, "key=[$key]" );
		}

		// Ÿե饰FALSEξϤΤޤ֤
		if ( $process_macro == NULL || !$process_macro ){
			return s($value);
		}

		// ޥŸֵ
		return ConfigUtil::processMacro( s($value) );
	}

	/*
	 * ͤȤƼ
	 */
	public function getArray( $key )
	{
		// ̤ʤ֤
		if ( !isset($this->_config[ $key ]) ){
			return array();
		}

		// ͤ
		$value = $this->_config[ $key ];

		// եޥåȳǧ
		if ( !is_array($value) ){
			throw new ArrayFormatException( $value, "key=[$key]" );
		}

		// ˤֵ
		return  $value;
	}

	/*
	 * ͤ֡ͤȤƼ
	 */
	public function getBoolean( $key )
	{
		// ̤ʤFALSE֤
		if ( !isset($this->_config[ $key ]) ){
			return FALSE;
		}

		// ͤ
		$value = $this->_config[ $key ];

		// եޥåȳǧ
		if ( !is_bool($value) ){
			throw new BooleanFormatException( $value, "key=[$key]" );
		}

		// ֡뷿ˤֵ
		return $value;
	}

	/*
	 * ͤͤȤƼ
	 */
	public function getInteger( $key )
	{
		// ̤ʤNULL֤
		if ( !isset($this->_config[ $key ]) ){
			return NULL;
		}

		// ͤ
		$value = $this->_config[ $key ];

		// եޥåȳǧ
		if ( !is_integer($value) ){
			throw new IntegerFormatException( $value, "key=[$key]" );
		}

		// ˤֵ
		return (int)$value;
	}

	/*
	 *ͤ
	 */
	public function dump( $key = NULL )
	{
		$title     = get_class($this);
		$line_end  = '<BR>';
		$indent    = '---';
		if ( $key ){
			// ΥФͤ
			$value = $this->_config[ $key ];
			System::dumpVar( $value, $title, $line_end, $indent );
		}
		else{
			// ٤Ƥͤ
			System::dumpArray( $this->_config, $title, $line_end, $indent );
		}
	}

}