<?php
/**
* URL򰷤饹
*
* PHP version 5
*
* @package    core
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/

class URL 
{
	var $_url_string;
	var $_scheme;
	var $_host;
	var $_port;
	var $_user;
	var $_pass;
	var $_path;
	var $_query;
	var $_fragment;
	var $_query_params;

	/*
	 *    󥹥ȥ饯
	 */
	public function __construct( $url_string )
	{
		$this->_url_string = $url_string;

		$url_parts = parse_url( $url_string );

		$this->_scheme   = isset( $url_parts[ 'scheme' ] )   ? $url_parts[ 'scheme' ]   : NULL;
		$this->_host     = isset( $url_parts[ 'host' ] )     ? $url_parts[ 'host' ]     : NULL;
		$this->_port     = isset( $url_parts[ 'port' ] )     ? $url_parts[ 'port' ]     : NULL;
		$this->_user     = isset( $url_parts[ 'user' ] )     ? $url_parts[ 'user' ]     : NULL;
		$this->_pass     = isset( $url_parts[ 'pass' ] )     ? $url_parts[ 'pass' ]     : NULL;
		$this->_path     = isset( $url_parts[ 'path' ] )     ? $url_parts[ 'path' ]     : NULL;
		$this->_query    = isset( $url_parts[ 'query' ] )    ? $url_parts[ 'query' ]    : NULL;
		$this->_fragment = isset( $url_parts[ 'fragment' ] ) ? $url_parts[ 'fragment' ] : NULL;

//print "scheme:" . $this->_scheme . "<BR>";
//print "host:" . $this->_host . "<BR>";

		$this->parseQuery();
	}

	/*
	 *    ꥹȥ󥰤
	 */
	private function parseQuery(){

		$this->_query_params = array();

		$params = explode( "&", $this->_query );

		foreach( $params as $p ){
			$field_value = explode( "=", $p );
			$field = isset($field_value[0]) ? $field_value[0] : NULL;
			$value = isset($field_value[1]) ? $field_value[1] : NULL;
			if ( $field ){
				$this->_query_params[ $field ] = $value;
			}
		}
	}

	/*
	 *    ѥ᡼
	 */
	public function setParameter( $field, $value ){
		$this->_query_params[ $field ] = $value;
		
		return $this;
	}

	/*
	 *    
	 */
	public function getScheme(){

		return $this->_scheme;
	}

	/*
	 *    ۥȤ
	 */
	public function getHost(){

		return $this->_host;
	}

	/*
	 *    ݡֹ
	 */
	public function getPort(){

		return $this->_port;
	}

	/*
	 *    桼
	 */
	public function getUser(){

		return $this->_user;
	}

	/*
	 *    ѥɤ
	 */
	public function getPass(){

		return $this->_pass;
	}

	/*
	 *    Хѥ
	 */
	public function getPath(){

		return $this->_path;
	}

	/*
	 *    ꡼ȥ󥰤
	 */
	public function getQuery(){

		return $this->_query;
	}

	/*
	 *    ե饰Ȥ
	 */
	public function getFragment(){

		return $this->_fragment;
	}

	/*
	 *    URLʸ
	 */
	public function getURLString(){

		return $this->_url_string;
	}

	/*
	 *    URLʸ
	 */
	public function makeURLString(){

		// scheme
		$url = $this->_scheme . "://";

		// user
		if ( $this->_user ){
			$url .= ":" . $this->_user;
		}

		// pass
		if ( $this->_pass ){
			$url .= ":" . $this->_pass;
		}

		// host
		if ( $this->_user || $this->_pass ){
			$url .= "@";
		}
		$url .= $this->_host;

		// port
		if ( $this->_port ){
			$url .= ":" . $this->_port;
		}

		// path
		$url .= $this->_path;

		// query
		if ( $this->_query_params && is_array($this->_query_params) ){
//			$url .= "?" . http_build_query( $this->_query_params );
			$url .= "?";
			foreach( $this->_query_params as $key => $value ){
				if ( !ereg("\?$",$url) ){
					$url .= "&";
				}
				$url .= $key . "=" . $value;
			}
		}

		// fragment
		if ( $this->_fragment ){
			$url .= "#" . $this->_fragment;
		}

		return $url;
	}

	/*
	 *    ʸɽ
	 */
	public function __toString(){

		$str = "";

		$str .= " [scheme]" . $this->_scheme;
		$str .= " [host]" . $this->_host;
		$str .= " [port]" . $this->_port;
		$str .= " [user]" . $this->_user;
		$str .= " [pass]" . $this->_pass;
		$str .= " [path]" . $this->_path;
		$str .= " [query]" . $this->_query;
		$str .= " [fragment]" . $this->_fragment;
		
		return "URL[" . $this->_url_string . "/" . $str . "]";
	}
}
